/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.EncodedValue.EncodedValueAdaptor;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.NullEncodedValue;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.util.IndentingWriter;

public class FieldDefinition {
    public static void writeTo(IndentingWriter writer, ClassDataItem.EncodedField encodedField, EncodedValue initialValue, AnnotationSetItem annotationSet, boolean setInStaticConstructor) throws IOException {
        String fieldTypeDescriptor = encodedField.field.getFieldType().getTypeDescriptor();
        if (setInStaticConstructor && encodedField.isStatic() && (encodedField.accessFlags & AccessFlags.FINAL.getValue()) != 0 && initialValue != null && (fieldTypeDescriptor.length() == 1 || initialValue != NullEncodedValue.NullValue)) {
            writer.write("#the value of this static final field might be set in the static constructor\n");
        }
        writer.write(".field ");
        FieldDefinition.writeAccessFlags(writer, encodedField);
        writer.write(encodedField.field.getFieldName().getStringValue());
        writer.write(58);
        writer.write(encodedField.field.getFieldType().getTypeDescriptor());
        if (initialValue != null) {
            writer.write(" = ");
            EncodedValueAdaptor.writeTo(writer, initialValue);
        }
        writer.write(10);
        if (annotationSet != null) {
            writer.indent(4);
            AnnotationFormatter.writeTo(writer, annotationSet);
            writer.deindent(4);
            writer.write(".end field\n");
        }
    }

    private static void writeAccessFlags(IndentingWriter writer, ClassDataItem.EncodedField encodedField) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForField((int)encodedField.accessFlags)) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }
}

