/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class DeletePrototypeOverrideAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;

    public DeletePrototypeOverrideAction(PluginTool tool, DecompilerController controller) {
        super("Remove Signature Override");
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Remove Signature Override"}, "Decompile"));
    }

    public static CodeSymbol getSymbol(DecompilerController controller) {
        DecompilerPanel decompilerPanel = controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return null;
        }
        Address addr = tokenAtCursor.getMinAddress();
        if (addr == null) {
            return null;
        }
        Function func = controller.getFunction();
        Namespace overspace = HighFunction.findOverrideSpace((Function)func);
        if (overspace == null) {
            return null;
        }
        SymbolTable symtab = func.getProgram().getSymbolTable();
        SymbolIterator iter = symtab.getSymbols(overspace);
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!sym.getName().startsWith("prt") || !(sym instanceof CodeSymbol) || !sym.getAddress().equals((Object)addr)) continue;
            return (CodeSymbol)sym;
        }
        return null;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = this.controller.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        return DeletePrototypeOverrideAction.getSymbol(this.controller) != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        CodeSymbol sym = DeletePrototypeOverrideAction.getSymbol(this.controller);
        Function func = this.controller.getFunction();
        Program program = func.getProgram();
        SymbolTable symtab = program.getSymbolTable();
        int transaction = program.startTransaction("Remove Override Signature");
        boolean commit = true;
        if (!symtab.removeSymbolSpecial((Symbol)sym)) {
            commit = false;
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.controller.getDecompilerPanel(), (String)"Removing Override Signature Failed", (Object)"Error removing override signature");
        }
        program.endTransaction(transaction, commit);
    }
}

