/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class ClangCommentToken
extends ClangToken {
    private Address srcaddr = null;

    public static ClangCommentToken derive(ClangCommentToken source, String text) {
        ClangCommentToken newToken = new ClangCommentToken(source.Parent());
        newToken.setText(text);
        newToken.setLineParent(source.getLineParent());
        newToken.setSyntaxType(source.getSyntaxType());
        newToken.setHighlight(source.getHighlight());
        newToken.srcaddr = source.srcaddr;
        return newToken;
    }

    public ClangCommentToken(ClangNode par) {
        super(par);
    }

    @Override
    public boolean isVariableRef() {
        return false;
    }

    @Override
    public Address getMinAddress() {
        return this.srcaddr;
    }

    @Override
    public Address getMaxAddress() {
        return this.srcaddr;
    }

    @Override
    public void restoreFromXML(XmlElement el, XmlElement end, PcodeFactory pfactory) {
        super.restoreFromXML(el, end, pfactory);
        String name = el.getAttribute("space");
        AddressSpace spc = pfactory.getAddressFactory().getAddressSpace(name);
        long offset = SpecXmlUtils.decodeLong((String)el.getAttribute("off"));
        this.srcaddr = spc.getAddress(offset);
    }
}

