/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class PdbErrorReaderThread
extends Thread {
    private InputStream err;
    private StringBuffer errbuf = new StringBuffer();

    PdbErrorReaderThread(InputStream err) {
        super("PdbErrorStreamReaderThread");
        this.err = err;
    }

    boolean hasErrors() {
        return this.errbuf.length() != 0 && this.errbuf.indexOf("ERROR") >= 0;
    }

    boolean hasWarnings() {
        return this.errbuf.length() != 0 && this.errbuf.indexOf("WARNING") >= 0;
    }

    String getErrorAndWarningMessages() {
        if (this.errbuf.length() == 0) {
            return null;
        }
        return this.errbuf.toString();
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.err));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.errbuf.append(line);
                this.errbuf.append('\n');
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Failed to read error stream.");
        }
    }
}

