/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.plugin.core.reloc.RelocationFixupHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;

public class ElfArmRelocationFixupHandler
extends RelocationFixupHandler {
    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        switch (relocation.getType()) {
            case 0: 
            case 2: 
            case 3: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return this.process32BitRelocation(program, relocation, oldImageBase, newImageBase);
            }
        }
        return false;
    }

    public boolean handlesProgram(Program program) {
        if (!"Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            return false;
        }
        Language language = program.getLanguage();
        if (language.getLanguageDescription().getSize() != 32) {
            return false;
        }
        Processor processor = language.getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"));
    }
}

