/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.sevenzipjbinding.IOutStream;
import net.sf.sevenzipjbinding.SevenZipException;

public class RandomAccessFileOutStream
implements IOutStream {
    private final RandomAccessFile randomAccessFile;

    public RandomAccessFileOutStream(RandomAccessFile randomAccessFile) {
        this.randomAccessFile = randomAccessFile;
    }

    public synchronized long seek(long l, int n) throws SevenZipException {
        try {
            switch (n) {
                case 0: {
                    this.randomAccessFile.seek(l);
                    break;
                }
                case 1: {
                    this.randomAccessFile.seek(this.randomAccessFile.getFilePointer() + l);
                    break;
                }
                case 2: {
                    this.randomAccessFile.seek(this.randomAccessFile.length() + l);
                    break;
                }
                default: {
                    throw new RuntimeException("Seek: unknown origin: " + n);
                }
            }
            return this.randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            throw new SevenZipException("Error while seek operation", iOException);
        }
    }

    public synchronized void setSize(long l) throws SevenZipException {
        try {
            this.randomAccessFile.setLength(l);
        }
        catch (IOException iOException) {
            throw new SevenZipException("Error setting new length of the file", iOException);
        }
    }

    public synchronized int write(byte[] byArray) throws SevenZipException {
        try {
            this.randomAccessFile.write(byArray);
            return byArray.length;
        }
        catch (IOException iOException) {
            throw new SevenZipException("Error reading random access file", iOException);
        }
    }

    public void close() throws IOException {
        this.randomAccessFile.close();
    }
}

