/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph.attributes;

import ghidra.util.Msg;
import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.attributes.Attribute;
import ghidra.util.graph.attributes.DoubleAttribute;
import ghidra.util.graph.attributes.IntegerAttribute;
import ghidra.util.graph.attributes.LongAttribute;
import ghidra.util.graph.attributes.ObjectAttribute;
import ghidra.util.graph.attributes.StringAttribute;
import java.util.Enumeration;
import java.util.Hashtable;

public class AttributeManager<T extends KeyedObject> {
    private KeyIndexableSet<T> attributedSet;
    private Hashtable<String, Attribute<T>> definedAttributes;
    public static final String INTEGER_TYPE = "INTEGER_TYPE";
    public static final String LONG_TYPE = "LONG_TYPE";
    public static final String DOUBLE_TYPE = "DOUBLE_TYPE";
    public static final String STRING_TYPE = "STRING_TYPE";
    public static final String OBJECT_TYPE = "OBJECT_TYPE";

    public AttributeManager(KeyIndexableSet<T> attributedSet) {
        this.attributedSet = attributedSet;
        this.definedAttributes = new Hashtable();
    }

    public Attribute<T> createAttribute(String attributeName, String attributeType) {
        Attribute newAttribute;
        if (attributeType.equals(INTEGER_TYPE)) {
            newAttribute = new IntegerAttribute<T>(attributeName, this.attributedSet);
            this.definedAttributes.put(attributeName, newAttribute);
        } else if (attributeType.equals(LONG_TYPE)) {
            newAttribute = new LongAttribute<T>(attributeName, this.attributedSet);
            this.definedAttributes.put(attributeName, newAttribute);
        } else if (attributeType.equals(DOUBLE_TYPE)) {
            newAttribute = new DoubleAttribute<T>(attributeName, this.attributedSet);
            this.definedAttributes.put(attributeName, newAttribute);
        } else if (attributeType.equals(STRING_TYPE)) {
            newAttribute = new StringAttribute<T>(attributeName, this.attributedSet);
            this.definedAttributes.put(attributeName, newAttribute);
        } else if (attributeType.equals(OBJECT_TYPE)) {
            newAttribute = new ObjectAttribute<T>(attributeName, this.attributedSet);
            this.definedAttributes.put(attributeName, newAttribute);
        } else {
            Msg.warn((Object)this, (Object)"Unknown attribute type. New Attribute is null");
            newAttribute = null;
        }
        return newAttribute;
    }

    public void removeAttribute(String attributeName) {
        this.definedAttributes.remove(attributeName);
    }

    public boolean hasAttributeNamed(String attributeName) {
        return this.definedAttributes.containsKey(attributeName);
    }

    public Attribute<T> getAttribute(String attributeName) {
        return this.definedAttributes.get(attributeName);
    }

    public String[] getAttributeNames() {
        String[] names = new String[]{};
        names = this.definedAttributes.keySet().toArray(names);
        return names;
    }

    public void clear() {
        Enumeration<Attribute<T>> enu = this.definedAttributes.elements();
        while (enu.hasMoreElements()) {
            Attribute<T> attr = enu.nextElement();
            attr.clear();
        }
    }
}

