/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.KeyedObjectFactory;

public class Vertex
implements KeyedObject,
Comparable<Vertex> {
    private final long key = vf.getNextAvailableKey();
    private final Object referent;
    private static final KeyedObjectFactory vf = KeyedObjectFactory.getInstance();

    public Vertex(Object referent) {
        this.referent = referent;
    }

    @Override
    public long key() {
        return this.key;
    }

    public String toString() {
        if (this.referent != null) {
            return this.referent.toString();
        }
        return "Nexus";
    }

    public boolean equals(Object o) {
        if (o instanceof Vertex) {
            return this.key == ((Vertex)o).key();
        }
        return false;
    }

    public Object referent() {
        return this.referent;
    }

    public int hashCode() {
        return (int)this.key;
    }

    @Override
    public int compareTo(Vertex v) {
        long difference = v.key() - this.key;
        if (difference < 0L) {
            return -1;
        }
        if (difference == 0L) {
            return 0;
        }
        return 1;
    }

    public String name() {
        if (this.referent != null) {
            return "Vertex:" + this.referent.toString().replace(' ', '_');
        }
        return "Vertex_" + Long.toHexString(this.key);
    }
}

