/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.io.Serializable;
import java.util.Arrays;

public class IntListIndexer
implements Serializable {
    private static final int END_OF_LIST = -1;
    private int[] heads;
    private int[] links;
    private int freePtr;
    private int size;
    private int capacity;
    private int numLists;

    public IntListIndexer(int numLists, int capacity) {
        this.capacity = capacity;
        this.numLists = numLists;
        this.links = new int[capacity];
        this.heads = new int[numLists];
        this.clear();
    }

    public int add(int listID) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException();
        }
        int index = this.allocate();
        if (index >= 0) {
            this.links[index] = this.heads[listID];
            this.heads[listID] = index;
        }
        return index;
    }

    public int append(int listID) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException();
        }
        int index = this.allocate();
        if (index >= 0) {
            if (this.heads[listID] == -1) {
                this.heads[listID] = index;
            } else {
                int p = this.heads[listID];
                while (this.links[p] != -1) {
                    p = this.links[p];
                }
                this.links[p] = index;
            }
        }
        return index;
    }

    public void remove(int listID, int index) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException("The listID is out of bounds");
        }
        if (index < 0 || index >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        int head = this.heads[listID];
        if (head == -1) {
            return;
        }
        if (head == index) {
            int temp = this.links[head];
            this.free(head);
            this.heads[listID] = temp;
            return;
        }
        int ptr = head;
        while (this.links[ptr] != -1) {
            if (this.links[ptr] == index) {
                this.links[ptr] = this.links[index];
                this.free(index);
                break;
            }
            ptr = this.links[ptr];
        }
    }

    public void removeAll(int listID) {
        int head = this.heads[listID];
        this.heads[listID] = -1;
        while (head != -1) {
            int temp = head;
            head = this.links[head];
            this.free(temp);
        }
    }

    public int getNewCapacity() {
        if (this.capacity == Integer.MAX_VALUE) {
            return -1;
        }
        int newCapacity = this.capacity < 0x3FFFFFFF ? this.capacity * 2 : Integer.MAX_VALUE;
        return newCapacity;
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getNumLists() {
        return this.numLists;
    }

    public final int next(int index) {
        return this.links[index];
    }

    public final int first(int listID) {
        return this.heads[listID];
    }

    public void growCapacity(int newCapacity) {
        if (newCapacity <= this.capacity) {
            return;
        }
        int[] temp = new int[newCapacity];
        System.arraycopy(this.links, 0, temp, 0, this.capacity);
        for (int i = this.capacity; i < newCapacity; ++i) {
            temp[i] = i + 1;
        }
        temp[newCapacity - 1] = -1;
        this.freePtr = this.capacity;
        this.capacity = newCapacity;
        this.links = temp;
    }

    public void growNumLists(int newListSize) {
        if (newListSize <= this.numLists) {
            return;
        }
        int[] temp = this.heads;
        this.heads = new int[newListSize];
        System.arraycopy(temp, 0, this.heads, 0, temp.length);
        Arrays.fill(this.heads, temp.length, this.heads.length, -1);
        this.numLists = newListSize;
    }

    public void clear() {
        for (int i = 0; i < this.capacity; ++i) {
            this.links[i] = i + 1;
        }
        this.links[this.capacity - 1] = -1;
        this.freePtr = 0;
        Arrays.fill(this.heads, -1);
        this.size = 0;
    }

    public int getListSize(int listID) {
        if (listID < 0 || listID >= this.numLists) {
            throw new IndexOutOfBoundsException("The listID is out of bounds");
        }
        int count = 0;
        int p = this.heads[listID];
        while (p != -1) {
            ++count;
            p = this.links[p];
        }
        return count;
    }

    private int allocate() {
        if (this.freePtr == -1) {
            this.growCapacity(this.getNewCapacity());
            if (this.freePtr == -1) {
                return -1;
            }
        }
        int p = this.freePtr;
        this.freePtr = this.links[this.freePtr];
        this.links[p] = -1;
        ++this.size;
        return p;
    }

    private void free(int p) {
        --this.size;
        this.links[p] = this.freePtr;
        this.freePtr = p;
    }
}

