/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;

public class PropertyBoolean
extends JCheckBox
implements ItemListener {
    private PropertyEditor editor;
    private boolean notifyEditorOfChanges = true;

    public PropertyBoolean(PropertyEditor pe) {
        this.setSelected((Boolean)pe.getValue());
        this.editor = pe;
        this.addItemListener(this);
        this.editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = PropertyBoolean.this.editor.getValue();
                if (value instanceof Boolean && !value.equals(PropertyBoolean.this.getText())) {
                    PropertyBoolean.this.notifyEditorOfChanges = false;
                    try {
                        PropertyBoolean.this.setSelected((Boolean)value);
                    }
                    finally {
                        PropertyBoolean.this.notifyEditorOfChanges = true;
                    }
                }
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.notifyEditorOfChanges) {
            try {
                this.editor.setValue(this.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

