/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class ProgressTracker {
    private long totalCount;
    private long inProgressCount;
    private long completedOrCancelledCount;
    private long nextID = 0L;
    private final ReentrantLock lock;
    private final Condition done;
    private final Condition itemCompleted;

    ProgressTracker(ReentrantLock lock) {
        this.lock = lock;
        this.done = lock.newCondition();
        this.itemCompleted = lock.newCondition();
    }

    void itemsAdded(int n) {
        this.lock.lock();
        try {
            this.totalCount += (long)n;
        }
        finally {
            this.lock.unlock();
        }
    }

    void itemStarted() {
        this.lock.lock();
        try {
            ++this.inProgressCount;
        }
        finally {
            this.lock.unlock();
        }
    }

    void InProgressitemCompletedOrCancelled() {
        this.lock.lock();
        try {
            ++this.completedOrCancelledCount;
            --this.inProgressCount;
            if (this.isDone()) {
                this.done.signalAll();
            }
            this.itemCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void neverStartedItemsRemoved(int n) {
        this.lock.lock();
        try {
            this.completedOrCancelledCount += (long)n;
            if (this.isDone()) {
                this.done.signalAll();
            }
            this.itemCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getCompletedItemCount() {
        this.lock.lock();
        try {
            long l = this.completedOrCancelledCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getTotalItemCount() {
        this.lock.lock();
        try {
            long l = this.totalCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getItemsInProgressCount() {
        this.lock.lock();
        try {
            long l = this.inProgressCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.completedOrCancelledCount == this.totalCount;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void waitUntilDone() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (!this.isDone()) {
                this.done.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void waitForNext() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (!this.isDone()) {
                this.itemCompleted.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilDone(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (!this.isDone()) {
                this.done.await(timeout, unit);
            }
            boolean bl = this.isDone();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getNextID() {
        this.lock.lock();
        try {
            long l = ++this.nextID;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

