/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import ghidra.util.exception.AssertException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class GClassLoader
extends URLClassLoader {
    public GClassLoader(List<File> moduleDirs) {
        super(GClassLoader.findUrls(moduleDirs), ClassLoader.getSystemClassLoader());
    }

    private static URL[] findUrls(List<File> moduleDirs) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File moduleDir : moduleDirs) {
            File binDir = new File(moduleDir, "bin/main");
            if (binDir.exists()) {
                GClassLoader.addFileURL(urls, binDir);
            }
            GClassLoader.addModuleJars(urls, new File(moduleDir, "lib"));
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addFileURL(List<URL> urls, File binDir) {
        try {
            urls.add(binDir.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new AssertException("Can't happen since we checked that it exists.");
        }
    }

    private static void addModuleJars(List<URL> urls, File libDir) {
        if (!libDir.isDirectory()) {
            return;
        }
        File[] listFiles = libDir.listFiles();
        if (listFiles != null) {
            for (File jarFile : listFiles) {
                if (!GClassLoader.isJarFile(jarFile)) continue;
                GClassLoader.addFileURL(urls, jarFile);
            }
        }
    }

    private static boolean isJarFile(File jarFile) {
        return jarFile.exists() && jarFile.getName().endsWith(".jar");
    }
}

