/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.testcode;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.GPTHeader;
import org.catacombae.hfsexplorer.partitioning.GUIDPartitionTable;
import org.catacombae.hfsexplorer.partitioning.MutableGPTEntry;
import org.catacombae.hfsexplorer.partitioning.MutableGPTHeader;
import org.catacombae.hfsexplorer.partitioning.MutableGUIDPartitionTable;
import org.catacombae.hfsexplorer.win32.WritableWin32File;
import org.catacombae.io.FileStream;
import org.catacombae.jparted.lib.ps.gpt.GPTPartitionType;

public class RepairMyGPTPlease6 {
    private static BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) throws Exception {
        long runTimeStamp = System.currentTimeMillis();
        WritableWin32File llf = WritableWin32File.isSystemSupported() ? new WritableWin32File(args[0]) : new FileStream(args[0]);
        GUIDPartitionTable originalGpt = new GUIDPartitionTable(llf, 0);
        MutableGUIDPartitionTable gpt = new MutableGUIDPartitionTable(originalGpt);
        if (originalGpt.isValid() && gpt.isValid()) {
            int blockSize = 512;
            GPTHeader hdr = gpt.getHeader();
            byte[] mbr = new byte[512];
            byte[] backup1 = new byte[512 + hdr.getNumberOfPartitionEntries() * hdr.getSizeOfPartitionEntry()];
            llf.seek(0L);
            llf.readFully(mbr);
            llf.readFully(backup1);
            String backupFilename1 = "gpt_mbr_tables-" + runTimeStamp + ".backup";
            System.out.print("Backing up MBR and GPT primary header and table to \"" + backupFilename1 + "\"...");
            FileOutputStream backupFile1 = new FileOutputStream(backupFilename1);
            backupFile1.write(mbr);
            backupFile1.write(backup1);
            backupFile1.close();
            System.out.println("done!");
            byte[] backup2 = new byte[hdr.getNumberOfPartitionEntries() * hdr.getSizeOfPartitionEntry() + 512];
            llf.seek(hdr.getBackupLBA() * 512L - (long)(hdr.getNumberOfPartitionEntries() * hdr.getSizeOfPartitionEntry()));
            llf.read(backup2);
            String backupFilename2 = "gpt_backup_table-" + runTimeStamp + ".backup";
            System.out.print("Backing up GPT backup header and table to \"" + backupFilename2 + "\"...");
            FileOutputStream backupFile2 = new FileOutputStream(backupFilename2);
            backupFile2.write(backup2);
            backupFile2.close();
            System.out.println("done!");
            byte[] efiSystemPartitionType = GPTPartitionType.PARTITION_TYPE_EFI_SYSTEM.getBytes();
            byte[] microsoftBasicDataType = GPTPartitionType.PARTITION_TYPE_PRIMARY_PARTITION.getBytes();
            byte[] appleHfsType = GPTPartitionType.PARTITION_TYPE_APPLE_HFS.getBytes();
            byte[] microsoftReservedType = GPTPartitionType.PARTITION_TYPE_MICROSOFT_RESERVED.getBytes();
            System.out.print("Checking if the second partition has type \"EFI System Partition\"...");
            byte[] currentType1 = gpt.getEntry(0).getPartitionTypeGUID();
            if (!Util.arraysEqual((byte[])currentType1, (byte[])efiSystemPartitionType)) {
                System.out.println("failed! Halting program.");
                System.exit(0);
            }
            System.out.println("yes.");
            System.out.print("Checking if the second partition has type \"Apple HFS\"...");
            byte[] currentType2 = gpt.getEntry(1).getPartitionTypeGUID();
            if (!Util.arraysEqual((byte[])currentType2, (byte[])appleHfsType)) {
                System.out.println("failed! Halting program.");
                System.exit(0);
            }
            System.out.println("yes.");
            System.out.print("Checking if the third partition has type \"Microsoft Basic Data\"...");
            byte[] currentType3 = gpt.getEntry(2).getPartitionTypeGUID();
            if (!Util.arraysEqual((byte[])currentType3, (byte[])microsoftBasicDataType)) {
                System.out.println("failed! Halting program.");
                System.exit(0);
            }
            System.out.println("yes.");
            System.out.print("Checking if the fourth partition has type \"Microsoft Basic Data\"...");
            byte[] currentType4 = gpt.getEntry(3).getPartitionTypeGUID();
            if (!Util.arraysEqual((byte[])currentType4, (byte[])microsoftBasicDataType)) {
                System.out.println("failed! Halting program.");
                System.exit(0);
            }
            System.out.println("yes.");
            System.out.println("All seems to be as expected.");
            System.out.println("Modifying GPT data in memory:");
            System.out.print("  - Setting new partition type for third partition...");
            MutableGPTEntry modifiedEntry1 = gpt.getMutablePrimaryEntry(2);
            MutableGPTEntry modifiedEntry2 = gpt.getMutableBackupEntry(2);
            modifiedEntry1.setPartitionTypeGUID(appleHfsType, 0);
            modifiedEntry2.setPartitionTypeGUID(appleHfsType, 0);
            System.out.println("done.");
            MutableGPTHeader primaryHeader = gpt.getMutablePrimaryHeader();
            MutableGPTHeader backupHeader = gpt.getMutableBackupHeader();
            System.out.print("  - Checking if calculated entries checksums match...");
            int entriesChecksum1 = gpt.calculatePrimaryEntriesChecksum();
            int entriesChecksum2 = gpt.calculateBackupEntriesChecksum();
            if (entriesChecksum1 != entriesChecksum2) {
                System.out.println("failed! Halting program.");
                System.exit(0);
            }
            System.out.println("yes.");
            primaryHeader.setPartitionEntryArrayCRC32(entriesChecksum1);
            backupHeader.setPartitionEntryArrayCRC32(entriesChecksum1);
            System.out.print("  - Checking if gpt.isValid() == false as it should be...");
            if (gpt.isValid()) {
                System.out.println("failed! Halting program.");
                System.exit(0);
            }
            System.out.println("yes.");
            System.out.print("  - Calculating header checksums...");
            primaryHeader.setCRC32Checksum(gpt.calculatePrimaryHeaderChecksum());
            backupHeader.setCRC32Checksum(gpt.calculateBackupHeaderChecksum());
            System.out.println("done.");
            System.out.print("  - Checking if gpt.isValid() == true as it now should be...");
            if (!gpt.isValid()) {
                System.out.println("failed! Halting program.");
                System.exit(0);
            }
            System.out.println("yes.");
            System.out.println("The table is now ready to be written down to disk.");
            System.out.print("Press enter to view the original table:");
            stdin.readLine();
            originalGpt.print(System.out, "");
            System.out.print("Press enter to view the modified table:");
            stdin.readLine();
            gpt.print(System.out, "");
            System.out.print("If you want to write this table to disk, type \"yes\" here: ");
            String answer = stdin.readLine();
            if (answer.equals("yes")) {
                System.out.print("Getting binary data for primary and backup tables...");
                byte[] newPrimaryGPT = gpt.getPrimaryTableBytes();
                byte[] newBackupGPT = gpt.getBackupTableBytes();
                System.out.println("done.");
                String newdataFilename1 = "gpt_mbr_tables-" + runTimeStamp + ".new";
                System.out.print("Writing old MBR and new GPT primary header and table to \"" + newdataFilename1 + "\"...");
                FileOutputStream newdataFile1 = new FileOutputStream(newdataFilename1);
                newdataFile1.write(mbr);
                newdataFile1.write(newPrimaryGPT);
                newdataFile1.close();
                System.out.println("done!");
                String newdataFilename2 = "gpt_backup_table-" + runTimeStamp + ".new";
                System.out.print("Writing new GPT backup header and table to \"" + newdataFilename2 + "\"...");
                FileOutputStream newdataFile2 = new FileOutputStream(newdataFilename2);
                newdataFile2.write(newBackupGPT);
                newdataFile2.close();
                System.out.println("done!");
                System.out.print("Writing primary table...");
                llf.seek(gpt.getPrimaryTableBytesOffset());
                llf.write(newPrimaryGPT);
                System.out.println("done!");
                System.out.print("Writing backup table...");
                llf.seek(gpt.getBackupTableBytesOffset());
                llf.write(newBackupGPT);
                System.out.println("done!");
                System.out.println();
                System.out.println("Checking the newly written GPT...");
                GUIDPartitionTable newGpt = new GUIDPartitionTable(llf, 0);
                newGpt.print(System.out, "");
                if (newGpt.isValid()) {
                    System.out.println("The GPT on disk is valid!");
                } else {
                    System.out.println("INVALID GPT ON DISK! FATAL ERROR!");
                    System.out.println("Try to restore the original GPT tables from the backups files:");
                    System.out.println("  " + backupFilename1);
                    System.out.println("  " + backupFilename2);
                    System.out.println("(dd in linux might do the job)");
                }
            } else {
                System.out.println("Exiting program without modifying anything.");
            }
        } else {
            System.out.println("Could not proceed! Detected an invalid GUID Partition Table on disk.");
        }
        llf.close();
    }
}

