/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.ProjectDataTreeActionContext;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyCutBaseAction;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.ResourceManager;

public class ProjectDataCopyAction
extends ProjectDataCopyCutBaseAction {
    private static Icon icon = ResourceManager.loadImage((String)"images/page_copy.png");

    public ProjectDataCopyAction(String owner, String group) {
        super("Copy", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Copy"}, icon, group));
        this.setKeyBindingData(new KeyBindingData('C', 128));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(ProjectDataTreeActionContext context) {
        TreePath[] paths = this.adjustSelectionPaths(context.getSelectionPaths());
        DataTreeClipboardUtils.setClipboardContents(context.getTree(), paths);
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataTreeActionContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        if (!context.isInActiveProject()) {
            return false;
        }
        return !context.containsRootFolder();
    }
}

