/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DialogComponentProvider;
import ghidra.framework.main.datatree.DomainFilesPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ChangedFilesDialog
extends DialogComponentProvider {
    private ArrayList<DomainFile> fileList;
    private DomainFilesPanel filePanel;
    private PluginTool tool;
    private boolean saveSelected;

    public ChangedFilesDialog(PluginTool tool, ArrayList<DomainFile> list) {
        super("Save Changed Files?", true);
        this.tool = tool;
        this.fileList = list;
        this.addWorkPanel(this.buildMainPanel());
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangedFilesDialog.this.save();
            }
        });
        saveButton.setToolTipText("Save files that have selected check boxes");
        this.addButton(saveButton);
        this.addCancelButton();
    }

    public void setCancelToolTipText(String toolTip) {
        this.setCancelToolTip(toolTip);
    }

    public boolean showDialog() {
        this.saveSelected = false;
        this.tool.showDialog(this);
        return this.saveSelected;
    }

    private JPanel buildMainPanel() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.filePanel = new DomainFilesPanel(this.fileList, "Changed Files");
        outerPanel.add((Component)this.filePanel, "Center");
        return outerPanel;
    }

    private void save() {
        this.saveSelected = true;
        DomainFile[] files = this.filePanel.getSelectedDomainFiles();
        if (files.length > 0) {
            SaveTask task = new SaveTask(files);
            this.tool.execute(task);
        } else {
            this.close();
        }
    }

    protected void cancelCallback() {
        this.close();
    }

    private class SaveTask
    extends Task {
        private DomainFile[] files;

        SaveTask(DomainFile[] files) {
            super(files.length > 1 ? "Saving Files..." : "Saving File", true, true, true);
            this.files = files;
        }

        public void run(TaskMonitor monitor) {
            for (DomainFile file : this.files) {
                if (monitor.isCancelled()) break;
                String name = file.getName();
                monitor.setProgress(0L);
                monitor.setMessage("Saving " + name);
                Msg.info((Object)((Object)this), (Object)("Successfully saved file: " + name));
                try {
                    file.save(monitor);
                }
                catch (CancelledException cancelledException) {
                }
                catch (IOException e) {
                    Msg.showError((Object)((Object)this), (Component)ChangedFilesDialog.this.tool.getToolFrame(), (String)"Error Saving File", (Object)("IO Exception while saving " + name), (Throwable)e);
                }
            }
            if (monitor.isCancelled()) {
                ChangedFilesDialog.this.saveSelected = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangedFilesDialog.this.close();
                }
            });
        }
    }
}

