/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileIDFactory;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class DBContentHandler
implements ContentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long createFile(DomainObjectAdapterDB domainObj, String contentType, FileSystem fs, String path, String name, TaskMonitor monitor) throws InvalidNameException, CancelledException, IOException {
        DBHandle dbh = domainObj.getDBHandle();
        ManagedBufferFile bf = fs.createDatabase(path, name, FileIDFactory.createFileID(), contentType, dbh.getBufferSize(), SystemUtilities.getUserName(), null);
        long checkoutId = bf.getCheckinID();
        boolean success = false;
        try {
            dbh.saveAs((BufferFile)bf, true, monitor);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    bf.delete();
                }
                catch (IOException iOException) {}
                this.abortCreate(fs, path, name, checkoutId);
            }
        }
        return checkoutId;
    }

    private void abortCreate(FileSystem fs, String path, String name, long checkoutId) {
        try {
            FolderItem item = fs.getItem(path, name);
            if (item != null) {
                if (checkoutId != -1L) {
                    item.terminateCheckout(checkoutId, false);
                }
                item.delete(-1, SystemUtilities.getUserName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getUserDataContentType(String associatedContentType) {
        return associatedContentType + "UserData";
    }

    @Override
    public final void saveUserDataFile(DomainObject domainObj, DBHandle userDbh, FileSystem userfs, TaskMonitor monitor) throws CancelledException, IOException {
        if (userfs.isVersioned()) {
            throw new IllegalArgumentException("User data file-system may not be versioned");
        }
        String associatedContentType = this.getContentType();
        DomainFile associatedDf = domainObj.getDomainFile();
        if (associatedDf == null) {
            throw new IllegalStateException("associated " + associatedContentType + " file must be saved before user data can be saved");
        }
        String associatedFileID = associatedDf.getFileID();
        if (associatedFileID == null) {
            Msg.error((Object)this, (Object)(associatedContentType + " '" + associatedDf.getName() + "' has not been assigned a file ID, user settings can not be saved!"));
            return;
        }
        String path = "/";
        String name = ProjectFileManager.getUserDataFilename(associatedFileID);
        ManagedBufferFile bf = null;
        boolean success = false;
        try {
            bf = userfs.createDatabase(path, name, FileIDFactory.createFileID(), DBContentHandler.getUserDataContentType(associatedContentType), userDbh.getBufferSize(), SystemUtilities.getUserName(), null);
            userDbh.saveAs((BufferFile)bf, true, monitor);
            success = true;
        }
        catch (InvalidNameException e) {
            throw new AssertException("Unexpected Error", (Throwable)e);
        }
        finally {
            if (bf != null && !success) {
                try {
                    bf.delete();
                }
                catch (IOException iOException) {}
                this.abortCreate(userfs, path, name, -1L);
            }
        }
    }

    @Override
    public final void removeUserDataFile(FolderItem associatedItem, FileSystem userfs) throws IOException {
        String path = "/";
        String name = ProjectFileManager.getUserDataFilename(associatedItem.getFileID());
        FolderItem item = userfs.getItem(path, name);
        if (item != null) {
            item.delete(-1, null);
        }
    }

    protected final DBHandle openAssociatedUserFile(String associatedFileID, String associatedContentType, FileSystem userfs, TaskMonitor monitor) throws IOException, CancelledException {
        String path = "/";
        String name = ProjectFileManager.getUserDataFilename(associatedFileID);
        FolderItem item = userfs.getItem(path, name);
        if (item == null || !(item instanceof DatabaseItem) || !DBContentHandler.getUserDataContentType(associatedContentType).equals(item.getContentType())) {
            return null;
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = dbItem.openForUpdate(-1L);
        return new DBHandle((BufferFile)bf, false, monitor);
    }
}

