/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.VariableLocation;

public class VariableTypeFieldLocation
extends VariableLocation {
    private String typeStr;

    public VariableTypeFieldLocation(Program program, Address locationAddr, Variable var, int charOffset) {
        super(program, locationAddr, var, 0, charOffset);
        this.typeStr = var.getDataType().getName();
    }

    public VariableTypeFieldLocation(Program program, Variable var, int charOffset) {
        super(program, var, 0, charOffset);
        this.typeStr = var.getDataType().getName();
    }

    public VariableTypeFieldLocation() {
    }

    public String getType() {
        return this.typeStr;
    }

    @Override
    public String toString() {
        return super.toString() + ", Function Variable Type = " + this.typeStr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.typeStr == null ? 0 : this.typeStr.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableTypeFieldLocation other = (VariableTypeFieldLocation)obj;
        return !(this.typeStr == null ? other.typeStr != null : !this.typeStr.equals(other.typeStr));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.typeStr = obj.getString("_TYPE_STR", "");
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_TYPE_STR", this.typeStr);
    }
}

