/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import docking.options.editor.StringWithChoicesEditor;
import generic.jar.ResourceFile;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighLanguageValidator;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.BitFieldPackingImpl;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.ContextSetting;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.PrototypeModelMerged;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.beans.PropertyEditor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BasicCompilerSpec
implements CompilerSpec {
    public static final String DECOMPILER_PROPERTY_LIST_NAME = "Decompiler";
    public static final String DECOMPILER_OUTPUT_LANGUAGE = "Output Language";
    public static final DecompilerLanguage DECOMPILER_OUTPUT_DEF = DecompilerLanguage.C_LANGUAGE;
    public static final String DECOMPILER_OUTPUT_DESC = "Select the source language output by the decompiler.";
    private static final String EVALUATION_MODEL_PROPERTY_NAME = "Prototype Evaluation";
    public static final String STACK_SPACE_NAME = "stack";
    public static final String JOIN_SPACE_NAME = "join";
    public static final String OTHER_SPACE_NAME = "OTHER";
    public static final int CONSTANT_SPACE_INDEX = 0;
    public static final int OTHER_SPACE_INDEX = 1;
    private final CompilerSpecDescription description;
    private String sourceName;
    private final SleighLanguage language;
    private DataOrganizationImpl dataOrganization;
    private List<ContextSetting> ctxsetting = new ArrayList<ContextSetting>();
    private PrototypeModel defaultModel;
    private PrototypeModel defaultEvaluationModel;
    private PrototypeModel[] models;
    private PrototypeModel[] evalmodels;
    private Register stackPointer;
    private AddressSpace stackSpace;
    private AddressSpace stackBaseSpace;
    private AddressSpace joinSpace;
    private boolean stackGrowsNegative = true;
    private boolean reverseJustifyStack = false;
    private Map<String, AddressSpace> spaceBases = new HashMap<String, AddressSpace>();
    private PcodeInjectLibrary pcodeInject;
    private AddressSet globalSet;
    private LinkedHashMap<String, String> properties = new LinkedHashMap();
    private Map<String, PrototypeModel> callingConventionMap = new HashMap<String, PrototypeModel>();
    private String[] evaluationModelChoices;
    private String specString;
    private ResourceFile specFile;
    private Exception parseException;

    public BasicCompilerSpec(CompilerSpecDescription description, SleighLanguage language, final ResourceFile cspecFile) throws CompilerSpecNotFoundException {
        this.description = description;
        this.language = language;
        this.buildInjectLibrary();
        this.dataOrganization = DataOrganizationImpl.getDefaultOrganization(language);
        this.specString = null;
        this.specFile = cspecFile;
        ErrorHandler errHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                BasicCompilerSpec.this.parseException = exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                BasicCompilerSpec.this.parseException = exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)this, (Object)("Warning parsing '" + cspecFile + "'"), (Throwable)exception);
            }
        };
        try {
            SleighLanguageValidator.validateCspecFile(cspecFile);
            InputStream stream = cspecFile.getInputStream();
            XmlPullParser parser = XmlPullParserFactory.create((InputStream)stream, (String)cspecFile.getAbsolutePath(), (ErrorHandler)errHandler, (boolean)false);
            this.initialize(cspecFile.getAbsolutePath(), parser);
            stream.close();
            if (this.models == null || this.models.length == 0) {
                throw new SAXException("No prototype models defined");
            }
        }
        catch (SleighException e) {
            this.parseException = e;
            Throwable cause = e.getCause();
            if (cause != null && (cause instanceof SAXException || cause instanceof IOException)) {
                this.parseException = (Exception)cause;
            }
        }
        catch (FileNotFoundException e) {
            this.parseException = e;
        }
        catch (IOException e) {
            this.parseException = e;
        }
        catch (SAXException e) {
            this.parseException = e;
        }
        catch (XmlParseException e) {
            this.parseException = e;
        }
        if (this.parseException != null) {
            throw new CompilerSpecNotFoundException(language.getLanguageID(), description.getCompilerSpecID(), cspecFile.getName(), this.parseException);
        }
    }

    private void initialize(String sourceName, XmlPullParser parser) throws XmlParseException {
        this.sourceName = sourceName;
        this.globalSet = new AddressSet();
        this.defaultModel = null;
        this.models = new PrototypeModel[0];
        this.restoreXml(parser);
        this.addThisCallConventionIfMissing();
    }

    private void buildInjectLibrary() {
        String classname = this.language.getProperty("pcodeInjectLibraryClass");
        if (classname == null) {
            this.pcodeInject = new PcodeInjectLibrary(this.language);
        } else {
            try {
                Class<?> c = Class.forName(classname);
                if (!PcodeInjectLibrary.class.isAssignableFrom(c)) {
                    Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid pcodeInjectLibraryClass"));
                    throw new RuntimeException(classname + " does not implement interface " + PcodeInjectLibrary.class.getName());
                }
                Class<?> injectLibraryClass = c;
                Constructor<?> constructor = injectLibraryClass.getConstructor(SleighLanguage.class);
                this.pcodeInject = (PcodeInjectLibrary)constructor.newInstance(this.language);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid pcodeInjectLibraryClass"));
                throw new RuntimeException("Failed to instantiate " + classname + " for language " + this.language.getLanguageID(), e);
            }
        }
        List<InjectPayloadSleigh> additionalInject = this.language.getAdditionalInject();
        if (additionalInject != null) {
            for (InjectPayloadSleigh payload : additionalInject) {
                this.pcodeInject.registerInject(payload.clone());
            }
        }
    }

    private void addThisCallConventionIfMissing() {
        boolean foundThisCall = false;
        for (PrototypeModel model : this.models) {
            if (!"__thiscall".equals(model.getName())) continue;
            foundThisCall = true;
            break;
        }
        if (this.defaultModel != null && !foundThisCall) {
            PrototypeModel[] newModels = new PrototypeModel[this.models.length + 1];
            System.arraycopy(this.models, 0, newModels, 0, this.models.length);
            PrototypeModel thisModel = new PrototypeModel("__thiscall", this.defaultModel);
            this.callingConventionMap.put("__thiscall", thisModel);
            newModels[this.models.length] = thisModel;
            this.models = newModels;
        }
    }

    public String getCompilerSpecString() throws FileNotFoundException, IOException {
        if (this.specString != null) {
            return this.specString;
        }
        InputStreamReader reader = new InputStreamReader(this.specFile.getInputStream());
        char[] cbuf = new char[1024];
        StringBuffer buf = new StringBuffer();
        int curlen = reader.read(cbuf);
        while (curlen > 0) {
            buf.append(cbuf, 0, curlen);
            curlen = reader.read(cbuf);
        }
        reader.close();
        this.specString = buf.toString();
        return this.specString;
    }

    @Override
    public void applyContextSettings(DefaultProgramContext programContext) {
        for (ContextSetting cs : this.ctxsetting) {
            RegisterValue registerValue = new RegisterValue(cs.getRegister(), cs.getValue());
            programContext.setDefaultValue(registerValue, cs.getStartAddress(), cs.getEndAddress());
        }
    }

    @Override
    public CompilerSpecID getCompilerSpecID() {
        return this.description.getCompilerSpecID();
    }

    @Override
    public boolean doesCDataTypeConversions() {
        return true;
    }

    void addContextSetting(Register reg, BigInteger value, Address begad, Address endad) {
        this.ctxsetting.add(new ContextSetting(reg, value, begad, endad));
    }

    @Override
    public PrototypeModel[] getCallingConventions() {
        return this.models;
    }

    @Override
    public PrototypeModel getCallingConvention(String name) {
        return this.callingConventionMap.get(name);
    }

    @Override
    public PrototypeModel getDefaultCallingConvention() {
        return this.defaultModel;
    }

    @Override
    public Register getStackPointer() {
        return this.stackPointer;
    }

    @Override
    public boolean isStackRightJustified() {
        return this.language.isBigEndian() && !this.reverseJustifyStack || !this.language.isBigEndian() && this.reverseJustifyStack;
    }

    @Override
    public AddressSpace getStackSpace() {
        return this.stackSpace;
    }

    @Override
    public AddressSpace getStackBaseSpace() {
        return this.stackBaseSpace;
    }

    @Override
    public PrototypeModel[] getNamedCallingConventions() {
        PrototypeModel[] tmpNamed = new PrototypeModel[this.models.length];
        int current = 0;
        for (int i = 0; i < tmpNamed.length; ++i) {
            if (this.models[i].getName() == null) continue;
            tmpNamed[current++] = this.models[i];
        }
        PrototypeModel[] named = new PrototypeModel[current];
        System.arraycopy(tmpNamed, 0, named, 0, current);
        return named;
    }

    @Override
    public boolean stackGrowsNegative() {
        return this.stackGrowsNegative;
    }

    @Override
    public boolean isGlobal(Address addr) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isOverlaySpace()) {
            addr = ((OverlayAddressSpace)space).translateAddress(addr, true);
        }
        return this.globalSet.contains(addr);
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public CompilerSpecDescription getCompilerSpecDescription() {
        return this.description;
    }

    private Register getRegister(String registerName) {
        Register reg = this.language.getRegister(registerName);
        if (reg == null) {
            throw new SleighException("Unknown register: " + registerName);
        }
        return reg;
    }

    @Override
    public AddressSpace getAddressSpace(String spaceName) {
        AddressSpace space;
        if (STACK_SPACE_NAME.equals(spaceName)) {
            space = this.stackSpace;
        } else if (JOIN_SPACE_NAME.equals(spaceName)) {
            if (this.joinSpace == null) {
                this.joinSpace = new GenericAddressSpace(JOIN_SPACE_NAME, 64, 6, 10);
            }
            space = this.joinSpace;
        } else {
            space = this.language.getAddressFactory().getAddressSpace(spaceName);
        }
        if (spaceName.equals(OTHER_SPACE_NAME)) {
            space = AddressSpace.OTHER_SPACE;
        }
        if (space == null) {
            throw new SleighException("Unknown address space: " + spaceName);
        }
        return space;
    }

    private void establishEvaluationModelChoices(PrototypeModel defaultEvaluationModel) {
        int i;
        int defaultnum = -1;
        for (i = 0; i < this.evalmodels.length; ++i) {
            if (this.evalmodels[i] != defaultEvaluationModel) continue;
            defaultnum = i;
        }
        if (defaultnum > 0) {
            PrototypeModel tmp = this.evalmodels[defaultnum];
            for (int i2 = defaultnum; i2 > 0; --i2) {
                this.evalmodels[i2] = this.evalmodels[i2 - 1];
            }
            this.evalmodels[0] = tmp;
        }
        this.evaluationModelChoices = new String[this.evalmodels.length];
        for (i = 0; i < this.evalmodels.length; ++i) {
            Object name = this.evalmodels[i].getName();
            if (name == null) {
                name = i == 0 ? "default" : "spec" + Integer.toString(i);
            }
            this.evaluationModelChoices[i] = name;
        }
    }

    private void buildModelArrays(List<PrototypeModel> modelList) {
        int fullcount = 0;
        int resolvecount = 0;
        for (PrototypeModel model : modelList) {
            ++fullcount;
            if (!model.isMerged()) continue;
            ++resolvecount;
        }
        this.models = new PrototypeModel[fullcount - resolvecount];
        this.evalmodels = new PrototypeModel[fullcount];
        int i = 0;
        int j = 0;
        for (PrototypeModel model : modelList) {
            if (model.isMerged()) {
                this.evalmodels[fullcount - resolvecount + j] = model;
                ++j;
                continue;
            }
            this.models[i] = model;
            this.evalmodels[i] = model;
            ++i;
        }
    }

    private void restoreXml(XmlPullParser parser) throws XmlParseException {
        this.stackPointer = null;
        ArrayList<PrototypeModel> modelList = new ArrayList<PrototypeModel>();
        String evalCurrentPrototype = null;
        parser.start(new String[]{"compiler_spec"});
        while (parser.peek().isStart()) {
            XmlElement el;
            String nm;
            String name = parser.peek().getName();
            if (name.equals("properties")) {
                this.readProperties(parser);
                continue;
            }
            if (name.equals("data_organization")) {
                this.restoreDataOrganization(parser);
                continue;
            }
            if (name.equals("callfixup")) {
                nm = parser.peek().getAttribute("name");
                this.pcodeInject.restoreXmlInject(this.sourceName, nm, 1, parser);
                continue;
            }
            if (name.equals("callotherfixup")) {
                nm = parser.peek().getAttribute("targetop");
                this.pcodeInject.restoreXmlInject(this.sourceName, nm, 2, parser);
                continue;
            }
            if (name.equals("context_data")) {
                this.restoreContextData(parser);
                continue;
            }
            if (name.equals("stackpointer")) {
                this.setStackPointer(parser);
                continue;
            }
            if (name.equals("spacebase")) {
                this.restoreSpaceBase(parser);
                continue;
            }
            if (name.equals("global")) {
                this.restoreGlobal(parser);
                continue;
            }
            if (name.equals("default_proto")) {
                parser.start(new String[0]);
                this.addPrototypeModel(modelList, parser, true);
                parser.end();
                continue;
            }
            if (name.equals("prototype")) {
                this.addPrototypeModel(modelList, parser, false);
                continue;
            }
            if (name.equals("resolveprototype")) {
                this.addPrototypeModel(modelList, parser, false);
                continue;
            }
            if (name.equals("eval_current_prototype")) {
                evalCurrentPrototype = parser.start(new String[0]).getAttribute("name");
                parser.end();
                continue;
            }
            if (name.equals("segmentop")) {
                el = parser.start(new String[0]);
                InjectPayloadSleigh payload = this.language.parseSegmentOp(el, parser);
                parser.end();
                this.pcodeInject.registerInject(payload);
                continue;
            }
            el = parser.start(new String[0]);
            parser.discardSubTree(el);
        }
        if (this.stackPointer == null) {
            this.stackSpace = new GenericAddressSpace(STACK_SPACE_NAME, this.language.getDefaultSpace().getSize(), this.language.getDefaultSpace().getAddressableUnitSize(), 5, 0);
        }
        this.buildModelArrays(modelList);
        for (PrototypeModel model : this.models) {
            String name = model.getName();
            if (name == null) continue;
            this.callingConventionMap.put(name, model);
        }
        this.defaultEvaluationModel = this.defaultModel;
        if (evalCurrentPrototype != null) {
            for (PrototypeModel evalmodel : this.evalmodels) {
                if (!evalmodel.getName().equals(evalCurrentPrototype)) continue;
                this.defaultEvaluationModel = evalmodel;
                break;
            }
        }
        this.establishEvaluationModelChoices(this.defaultEvaluationModel);
        parser.end();
    }

    private void readProperties(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            if (el.getName().equals("property")) {
                String key = el.getAttribute("key");
                String value = el.getAttribute("value");
                this.properties.put(key, value);
                parser.end(el);
                continue;
            }
            parser.discardSubTree(el);
        }
        parser.end();
    }

    private void restoreDataOrganization(XmlPullParser parser) throws XmlParseException {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String name = subel.getName();
            if (name.equals("char_type")) {
                String boolStr = subel.getAttribute("signed");
                this.dataOrganization.setCharIsSigned(SpecXmlUtils.decodeBoolean((String)boolStr));
                parser.end(subel);
                continue;
            }
            String value = subel.getAttribute("value");
            if (name.equals("absolute_max_alignment")) {
                this.dataOrganization.setAbsoluteMaxAlignment(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("machine_alignment")) {
                this.dataOrganization.setMachineAlignment(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("default_alignment")) {
                this.dataOrganization.setDefaultAlignment(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("default_pointer_alignment")) {
                this.dataOrganization.setDefaultPointerAlignment(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("pointer_size")) {
                this.dataOrganization.setPointerSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("pointer_shift")) {
                this.dataOrganization.setPointerShift(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("char_size")) {
                this.dataOrganization.setCharSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("wchar_size")) {
                this.dataOrganization.setWideCharSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("short_size")) {
                this.dataOrganization.setShortSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("integer_size")) {
                this.dataOrganization.setIntegerSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("long_size")) {
                this.dataOrganization.setLongSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("long_long_size")) {
                this.dataOrganization.setLongLongSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("float_size")) {
                this.dataOrganization.setFloatSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("double_size")) {
                this.dataOrganization.setDoubleSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("long_double_size")) {
                this.dataOrganization.setLongDoubleSize(SpecXmlUtils.decodeInt((String)value));
            } else if (name.equals("size_alignment_map")) {
                this.dataOrganization.clearSizeAlignmentMap();
                while (parser.peek().isStart()) {
                    XmlElement subsubel = parser.start(new String[0]);
                    int size = SpecXmlUtils.decodeInt((String)subsubel.getAttribute("size"));
                    int alignment = SpecXmlUtils.decodeInt((String)subsubel.getAttribute("alignment"));
                    this.dataOrganization.setSizeAlignment(size, alignment);
                    parser.end(subsubel);
                }
            } else if (name.equals("bitfield_packing")) {
                this.dataOrganization.setBitFieldPacking(this.parseBitFieldPacking(parser));
            }
            parser.end(subel);
        }
        parser.end();
    }

    private BitFieldPacking parseBitFieldPacking(XmlPullParser parser) {
        BitFieldPackingImpl bitFieldPacking = new BitFieldPackingImpl();
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String name = subel.getName();
            String value = subel.getAttribute("value");
            if (name.equals("use_MS_convention")) {
                bitFieldPacking.setUseMSConvention(SpecXmlUtils.decodeBoolean((String)value));
            } else if (name.equals("type_alignment_enabled")) {
                bitFieldPacking.setTypeAlignmentEnabled(SpecXmlUtils.decodeBoolean((String)value));
            } else if (name.equals("zero_length_boundary")) {
                bitFieldPacking.setZeroLengthBoundary(SpecXmlUtils.decodeInt((String)value));
            }
            parser.end(subel);
        }
        return bitFieldPacking;
    }

    private void restoreSpaceBase(XmlPullParser parser) {
        XmlElement el = parser.start(new String[0]);
        String name = el.getAttribute("name");
        this.getRegister(el.getAttribute("register"));
        String spaceName = el.getAttribute("space");
        if (this.language.getAddressFactory().getAddressSpace(name) != null || this.spaceBases.containsKey(name)) {
            throw new SleighException("Duplicate space name: " + name);
        }
        AddressSpace space = this.getAddressSpace(spaceName);
        this.spaceBases.put(name, space);
        parser.end(el);
    }

    private void restoreGlobal(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String name = subel.getName();
            if (name.equals("range")) {
                AddressRange range = this.getAddressRange(subel);
                if (range != null) {
                    this.globalSet.add(range);
                }
            } else if (name.equals("register")) {
                String regName = subel.getAttribute("name");
                Register reg = this.getRegister(regName);
                this.globalSet.addRange(reg.getAddress(), reg.getAddress().add(reg.getMinimumByteSize() - 1));
            }
            parser.end(subel);
        }
        parser.end();
    }

    private void restoreContextData(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            String name = parser.peek().getName();
            if (name.equals("context_set")) {
                this.addContextSet(parser);
                continue;
            }
            if (!name.equals("tracked_set")) continue;
            this.addTrackedSet(parser);
        }
        parser.end();
    }

    private void addTrackedSet(XmlPullParser parser) {
        XmlElement el = parser.start(new String[0]);
        AddressRange range = this.getAddressRange(el);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            this.ctxsetting.add(this.getContextSetting(subel, range, false));
            parser.end(subel);
        }
        parser.end(el);
    }

    private void addContextSet(XmlPullParser parser) {
        XmlElement el = parser.start(new String[0]);
        AddressRange range = this.getAddressRange(el);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            this.ctxsetting.add(this.getContextSetting(subel, range, true));
            parser.end(subel);
        }
        parser.end(el);
    }

    private ContextSetting getContextSetting(XmlElement setElement, AddressRange range, boolean isContextReg) {
        String name = setElement.getAttribute("name");
        BigInteger val = this.getBigInteger(setElement.getAttribute("val"), 0L);
        Register reg = this.getRegister(name);
        if (isContextReg) {
            if (!reg.isProcessorContext()) {
                throw new SleighException("Register " + name + " is not a context register");
            }
        } else if (reg.isProcessorContext()) {
            throw new SleighException("Unexpected context register " + name);
        }
        return new ContextSetting(reg, val, range.getMinAddress(), range.getMaxAddress());
    }

    private AddressRange getAddressRange(XmlElement setParentElement) {
        String spaceName = setParentElement.getAttribute("space");
        if (this.spaceBases.containsKey(spaceName)) {
            return null;
        }
        AddressSpace addrspace = this.getAddressSpace(spaceName);
        long first = addrspace.getMinAddress().getOffset();
        long last = addrspace.getMaxAddress().getOffset();
        String valstring = setParentElement.getAttribute("first");
        if (valstring != null) {
            first = SpecXmlUtils.decodeLong((String)valstring);
        }
        if ((valstring = setParentElement.getAttribute("last")) != null) {
            last = SpecXmlUtils.decodeLong((String)valstring);
        }
        Address firstAddress = addrspace.getAddress(first);
        Address lastAddress = addrspace.getAddress(last);
        return new AddressRangeImpl(firstAddress, lastAddress);
    }

    private void setStackPointer(XmlPullParser parser) {
        String growth;
        XmlElement el = parser.start(new String[0]);
        this.stackPointer = this.getRegister(el.getAttribute("register"));
        String baseSpaceName = el.getAttribute("space");
        this.stackBaseSpace = this.getAddressSpace(baseSpaceName);
        if (this.stackBaseSpace == null) {
            throw new SleighException("Undefined base stack space: " + baseSpaceName);
        }
        int stackSpaceSize = Math.min(this.stackPointer.getBitLength(), this.stackBaseSpace.getSize());
        this.stackSpace = new GenericAddressSpace(STACK_SPACE_NAME, stackSpaceSize, this.stackBaseSpace.getAddressableUnitSize(), 5, 0);
        String reverseJustifyStr = el.getAttribute("reversejustify");
        if (reverseJustifyStr != null) {
            this.reverseJustifyStack = this.getBooleanValue(reverseJustifyStr);
        }
        if ((growth = el.getAttribute("growth")) == null || growth.equals("negative")) {
            this.stackGrowsNegative = true;
        } else if (growth.equals("positive")) {
            this.stackGrowsNegative = false;
        } else {
            throw new SleighException("Bad stack growth " + growth + " should be 'positive' or 'negative'");
        }
        parser.end(el);
    }

    private boolean getBooleanValue(String booleanStr) {
        return "1".equals(booleanStr) || "true".equalsIgnoreCase(booleanStr);
    }

    private BigInteger getBigInteger(String valStr, long defaultValue) {
        int radix = 10;
        if (valStr.startsWith("0x") || valStr.startsWith("0X")) {
            valStr = valStr.substring(2);
            radix = 16;
        }
        try {
            return new BigInteger(valStr, radix);
        }
        catch (Exception e) {
            return BigInteger.valueOf(defaultValue);
        }
    }

    private void addPrototypeModel(List<PrototypeModel> modelList, XmlPullParser parser, boolean isDefault) throws XmlParseException {
        PrototypeModel model;
        if (parser.peek().getName().equals("resolveprototype")) {
            PrototypeModelMerged mergemodel = new PrototypeModelMerged();
            mergemodel.restoreXml(parser, modelList, this.stackGrowsNegative);
            model = mergemodel;
        } else {
            model = new PrototypeModel();
            model.restoreXml(parser, this, this.stackGrowsNegative);
        }
        if (this.defaultModel == null || isDefault) {
            this.defaultModel = model;
        }
        modelList.add(model);
    }

    @Override
    public DataOrganization getDataOrganization() {
        return this.dataOrganization;
    }

    private String getPrototypeEvaluationModelChoice(Program program) {
        Options options = program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        return options.getString(EVALUATION_MODEL_PROPERTY_NAME, (String)null);
    }

    @Override
    public Object getPrototypeEvaluationModel(Program program) {
        String modelName = this.getPrototypeEvaluationModelChoice(program);
        for (int i = 0; i < this.evaluationModelChoices.length; ++i) {
            if (!this.evaluationModelChoices[i].equals(modelName)) continue;
            return this.evalmodels[i];
        }
        return null;
    }

    @Override
    public DecompilerLanguage getDecompilerOutputLanguage(Program program) {
        Options options = program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        if (options.contains(DECOMPILER_OUTPUT_LANGUAGE)) {
            return (DecompilerLanguage)options.getEnum(DECOMPILER_OUTPUT_LANGUAGE, (Enum)DECOMPILER_OUTPUT_DEF);
        }
        return DECOMPILER_OUTPUT_DEF;
    }

    @Override
    public void registerProgramOptions(Program program) {
        Options decompilerPropertyList = program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        decompilerPropertyList.registerOption(EVALUATION_MODEL_PROPERTY_NAME, OptionType.STRING_TYPE, (Object)this.evaluationModelChoices[0], null, "Select the default function prototype/evaluation model to be used during Decompiler analysis", (PropertyEditor)new StringWithChoicesEditor(this.evaluationModelChoices));
        if (decompilerPropertyList.contains(DECOMPILER_OUTPUT_LANGUAGE)) {
            decompilerPropertyList.registerOption(DECOMPILER_OUTPUT_LANGUAGE, (Object)DECOMPILER_OUTPUT_DEF, null, DECOMPILER_OUTPUT_DESC);
        }
        Options analysisPropertyList = program.getOptions("Analyzers.Decompiler Parameter ID");
        analysisPropertyList.createAlias(EVALUATION_MODEL_PROPERTY_NAME, decompilerPropertyList, EVALUATION_MODEL_PROPERTY_NAME);
    }

    @Override
    public PrototypeModel matchConvention(GenericCallingConvention genericCallingConvention) {
        if (genericCallingConvention == GenericCallingConvention.unknown) {
            return this.defaultModel;
        }
        for (PrototypeModel model : this.models) {
            if (model.getGenericCallingConvention() != genericCallingConvention) continue;
            return model;
        }
        return this.defaultModel;
    }

    @Override
    public PrototypeModel findBestCallingConvention(Parameter[] params) {
        if (!this.defaultEvaluationModel.isMerged()) {
            return this.defaultEvaluationModel;
        }
        return ((PrototypeModelMerged)this.defaultEvaluationModel).selectModel(params);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public String getProperty(String key, String defaultString) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return defaultString;
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultBoolean) {
        if (this.properties.containsKey(key)) {
            return Boolean.parseBoolean(this.properties.get(key));
        }
        return defaultBoolean;
    }

    @Override
    public int getPropertyAsInt(String key, int defaultInt) {
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.get(key));
        }
        return defaultInt;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public PcodeInjectLibrary getPcodeInjectLibrary() {
        return this.pcodeInject;
    }

    public static void enableJavaLanguageDecompilation(Program program) {
        Options decompilerPropertyList = program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        decompilerPropertyList.registerOption(DECOMPILER_OUTPUT_LANGUAGE, (Object)DECOMPILER_OUTPUT_DEF, null, DECOMPILER_OUTPUT_DESC);
        decompilerPropertyList.setEnum(DECOMPILER_OUTPUT_LANGUAGE, (Enum)DecompilerLanguage.JAVA_LANGUAGE);
    }
}

