/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBHandle;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.store.LockException;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.ByteSourceRange;
import ghidra.program.database.mem.ByteSourceRangeList;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.FileBytesAdapter;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSetViewAdapter;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.program.model.mem.LiveMemoryListener;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockStub;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Lock;
import ghidra.util.MonitoredInputStream;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MemoryMapDB
implements Memory,
ManagerDB,
LiveMemoryListener {
    private ProgramDB program;
    private AddressMapDB addrMap;
    private MemoryMapDBAdapter adapter;
    private FileBytesAdapter fileBytesAdapter;
    private static final DataConverter BIG_ENDIAN = BigEndianDataConverter.INSTANCE;
    private static final DataConverter LITTLE_ENDIAN = LittleEndianDataConverter.INSTANCE;
    private DataConverter defaultEndian;
    private List<MemoryBlockDB> blocks;
    private AddressSet addrSet = new AddressSet();
    private AddressSet initializedLoadedAddrSet = new AddressSet();
    private AddressSet allInitializedAddrSet = new AddressSet();
    private AddressSetView executeSet = null;
    private MemoryBlock lastBlock;
    private LiveMemoryHandler liveMemory;
    private HashMap<String, MemoryBlock> nameBlockMap = new HashMap();
    private static final MemoryBlock NoBlock = new MemoryBlockStub();
    Lock lock;
    private Set<MemoryBlock> potentialOverlappingBlocks;
    private static Comparator<Object> BLOCK_ADDRESS_COMPARATOR = (o1, o2) -> {
        MemoryBlock block = (MemoryBlock)o1;
        Address addr = (Address)o2;
        return block.getStart().compareTo(addr);
    };

    public MemoryMapDB(DBHandle handle, AddressMapDB addrMap, int openMode, boolean isBigEndian, Lock lock, TaskMonitor monitor) throws IOException, VersionException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.defaultEndian = isBigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
        this.adapter = MemoryMapDBAdapter.getAdapter(handle, openMode, this, monitor);
        this.fileBytesAdapter = FileBytesAdapter.getAdapter(handle, openMode, monitor);
        this.initializeBlocks();
        this.buildAddressSets();
    }

    MemoryMapDB(DBHandle handle, AddressMapDB addrMap, int openMode, boolean isBigEndian, Lock lock) {
        this.addrMap = addrMap;
        this.lock = lock;
        this.defaultEndian = isBigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    void init(MemoryMapDBAdapter memoryAdapter, FileBytesAdapter bytesAdapter) {
        this.adapter = memoryAdapter;
        this.fileBytesAdapter = bytesAdapter;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.lock.acquire();
        try {
            this.reloadAll();
        }
        finally {
            this.lock.release();
        }
    }

    private void buildAddressSets() {
        this.addrSet = new AddressSet();
        this.initializedLoadedAddrSet = new AddressSet();
        this.allInitializedAddrSet = new AddressSet();
        for (MemoryBlockDB block : this.blocks) {
            if (block.isMapped()) continue;
            this.addBlockAddresses(block);
        }
        for (MemoryBlockDB block : this.blocks) {
            if (!block.isMapped()) continue;
            this.addBlockAddresses(block);
        }
    }

    private void addBlockAddresses(MemoryBlockDB block) {
        AddressSet blockSet = new AddressSet(block.getStart(), block.getEnd());
        this.addrSet = this.addrSet.union(blockSet);
        if (block.isMapped()) {
            this.allInitializedAddrSet = this.allInitializedAddrSet.union(this.getMappedIntersection(block, this.allInitializedAddrSet));
            this.initializedLoadedAddrSet = this.initializedLoadedAddrSet.union(this.getMappedIntersection(block, this.initializedLoadedAddrSet));
        } else if (block.isInitialized()) {
            this.allInitializedAddrSet = this.allInitializedAddrSet.union(blockSet);
            if (block.isLoaded()) {
                this.initializedLoadedAddrSet = this.initializedLoadedAddrSet.union(blockSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadAll() throws IOException {
        MemoryMapDB memoryMapDB = this;
        synchronized (memoryMapDB) {
            this.fileBytesAdapter.refresh();
            this.adapter.refreshMemory();
            this.initializeBlocks();
            this.buildAddressSets();
        }
        if (this.liveMemory != null) {
            this.liveMemory.clearCache();
        }
        this.addrMap.memoryMapChanged(this);
    }

    private synchronized void initializeBlocks() {
        List<MemoryBlockDB> newBlocks = this.adapter.getMemoryBlocks();
        this.lastBlock = null;
        this.blocks = newBlocks;
        this.addrMap.memoryMapChanged(this);
        this.nameBlockMap = new HashMap();
        this.executeSet = null;
    }

    public void setLanguage(Language newLanguage) {
        this.defaultEndian = newLanguage.isBigEndian() ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        try {
            this.reloadAll();
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 3) {
            for (MemoryBlock memoryBlock : this.blocks) {
                this.addrMap.getKey(memoryBlock.getEnd(), true);
            }
        }
    }

    void dbError(IOException e) {
        this.program.dbError(e);
    }

    AddressFactory getAddressFactory() {
        return this.addrMap.getAddressFactory();
    }

    AddressMapDB getAddressMap() {
        return this.addrMap;
    }

    @Override
    public AddressSetView getInitializedAddressSet() {
        return this.getLoadedAndInitializedAddressSet();
    }

    @Override
    public AddressSetView getAllInitializedAddressSet() {
        return new AddressSetViewAdapter(this.allInitializedAddrSet);
    }

    @Override
    public AddressSetView getLoadedAndInitializedAddressSet() {
        if (this.liveMemory != null) {
            return this;
        }
        return new AddressSetViewAdapter(this.initializedLoadedAddrSet);
    }

    void checkMemoryWrite(MemoryBlockDB block, Address start, long length) throws MemoryAccessException {
        this.checkRangeForInstructions(start, start.add(length - 1L));
        Set<MemoryBlock> overlappingBlocks = this.getPotentialOverlappingBlocks();
        ByteSourceRangeList changeingByteSource = block.getByteSourceRangeList(start, length);
        if (overlappingBlocks.contains(block)) {
            for (MemoryBlock b : overlappingBlocks) {
                if (b.equals(block)) continue;
                ByteSourceRangeList set = ((MemoryBlockDB)b).getByteSourceRangeList(b.getStart(), b.getSize());
                ByteSourceRangeList intersect = set.intersect(changeingByteSource);
                for (ByteSourceRange range : intersect) {
                    this.checkRangeForInstructions(range.getStart(), range.getEnd());
                }
            }
        }
    }

    private Set<MemoryBlock> getPotentialOverlappingBlocks() {
        if (this.potentialOverlappingBlocks == null) {
            ByteSourceRangeList byteSourceList = new ByteSourceRangeList();
            for (MemoryBlockDB block : this.blocks) {
                byteSourceList.add(block.getByteSourceRangeList(block.getStart(), block.getSize()));
            }
            this.potentialOverlappingBlocks = byteSourceList.getOverlappingBlocks();
        }
        return this.potentialOverlappingBlocks;
    }

    @Override
    public MemoryBlock getBlock(Address addr) {
        return this.getBlockDB(addr);
    }

    @Override
    public synchronized MemoryBlock getBlock(String blockName) {
        MemoryBlock memoryBlock = this.nameBlockMap.get(blockName);
        if (memoryBlock != null) {
            if (memoryBlock == NoBlock) {
                return null;
            }
            return memoryBlock;
        }
        for (MemoryBlock memoryBlock2 : this.blocks) {
            if (!memoryBlock2.getName().equals(blockName)) continue;
            this.nameBlockMap.put(blockName, memoryBlock2);
            return memoryBlock2;
        }
        this.nameBlockMap.put(blockName, NoBlock);
        return null;
    }

    private synchronized MemoryBlock getBlockDB(Address addr) {
        MemoryBlock block;
        if (this.lastBlock != null && this.lastBlock.contains(addr)) {
            return this.lastBlock;
        }
        List<MemoryBlockDB> tmpBlocks = this.blocks;
        int index = Collections.binarySearch(tmpBlocks, addr, BLOCK_ADDRESS_COMPARATOR);
        if (index >= 0) {
            this.lastBlock = tmpBlocks.get(index);
            return this.lastBlock;
        }
        if ((index = -index - 2) >= 0 && (block = (MemoryBlock)tmpBlocks.get(index)).contains(addr)) {
            this.lastBlock = block;
            return block;
        }
        return null;
    }

    void fireBlockAdded(MemoryBlock newBlock) {
        AddressRangeImpl range = new AddressRangeImpl(newBlock.getStart(), newBlock.getEnd());
        this.program.getTreeManager().addMemoryBlock(newBlock.getName(), range);
        this.program.setChanged(20, newBlock.getStart(), newBlock.getEnd(), null, null);
        this.program.fireEvent(new DomainObjectChangeRecord(4));
    }

    void fireBlockSplit() {
        this.program.fireEvent(new DomainObjectChangeRecord(4));
    }

    void fireBlockRemoved(Address blockStartAddr) {
        this.program.setChanged(21, blockStartAddr, null);
        this.program.fireEvent(new DomainObjectChangeRecord(4));
    }

    void fireBlockMoved(MemoryBlockDB block, Address oldStartAddr) {
        this.program.setChanged(25, oldStartAddr, block);
        this.program.fireEvent(new DomainObjectChangeRecord(4));
    }

    void fireBlocksJoined(MemoryBlock newBlock, Address oldBlockStartAddr) {
        this.program.setChanged(25, oldBlockStartAddr, newBlock);
    }

    void fireBlockSplit(MemoryBlockDB originalBlock, MemoryBlockDB newBlock) {
        this.program.setChanged(24, null, null, originalBlock, newBlock);
    }

    void fireBlockChanged(MemoryBlock block) {
        if (this.program != null) {
            this.program.setChanged(22, block, null);
        }
        this.nameBlockMap = new HashMap();
        this.executeSet = null;
    }

    void fireBytesChanged(Address addr, int count) {
        this.lock.acquire();
        try {
            Address end = addr.addNoWrap(count - 1);
            this.program.getCodeManager().memoryChanged(addr, end);
            this.program.setChanged(26, addr, end, null, null);
        }
        catch (AddressOverflowException e) {
            throw new AssertException(e.getMessage());
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isBigEndian() {
        return this.defaultEndian == BIG_ENDIAN;
    }

    @Override
    public void setLiveMemoryHandler(LiveMemoryHandler handler) {
        this.lock.acquire();
        try {
            if (this.liveMemory != null) {
                this.liveMemory.removeLiveMemoryListener(this);
            }
            this.liveMemory = handler;
            if (this.liveMemory != null) {
                this.liveMemory.addLiveMemoryListener(this);
            }
            this.program.invalidate();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public LiveMemoryHandler getLiveMemoryHandler() {
        return this.liveMemory;
    }

    @Override
    public MemoryBlock createInitializedBlock(String name, Address start, long size, byte initialValue, TaskMonitor monitor, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException, DuplicateNameException {
        InputStream fillStream = null;
        if (initialValue != 0) {
            final int fillByte = initialValue & 0xFF;
            fillStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return fillByte;
                }
            };
        }
        return this.createInitializedBlock(name, start, fillStream, size, monitor, overlay);
    }

    private Address createOverlaySpace(String name, Address start, long dataLength) throws MemoryConflictException, AddressOverflowException, DuplicateNameException, LockException {
        AddressSpace space = start.getAddressSpace();
        if (space.isOverlaySpace()) {
            throw new IllegalArgumentException("An overlay block may not be overlayed");
        }
        if (!space.isMemorySpace()) {
            throw new IllegalArgumentException("Invalid physical address for overlay block: " + start.toString(true));
        }
        start.addNoWrap(dataLength - 1L);
        AddressSpace ovSpace = this.program.addOverlaySpace(name, start.getAddressSpace(), start.getOffset(), start.getOffset() + (dataLength - 1L));
        Address ovAddr = ovSpace.getAddress(start.getOffset());
        return ovAddr;
    }

    /*
     * Exception decompiling
     */
    @Override
    public MemoryBlock createInitializedBlock(String name, Address start, InputStream is, long length, TaskMonitor monitor, boolean overlay) throws MemoryConflictException, AddressOverflowException, CancelledException, LockException, DuplicateNameException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock createInitializedBlock(String name, Address start, FileBytes fileBytes, long offset, long length, boolean overlay) throws LockException, DuplicateNameException, MemoryConflictException, AddressOverflowException, IndexOutOfBoundsException {
        Objects.requireNonNull(name);
        this.lock.acquire();
        try {
            this.checkBlockSize(length, true);
            this.program.checkExclusiveAccess();
            this.checkFileBytesRange(fileBytes, offset, length);
            if (overlay) {
                start = this.createOverlaySpace(name, start, length);
            } else {
                this.checkRange(start, length);
            }
            try {
                MemoryBlockDB newBlock = this.adapter.createFileBytesBlock(name, start, length, fileBytes, offset, 4);
                this.initializeBlocks();
                this.addBlockAddresses(newBlock);
                this.fireBlockAdded(newBlock);
                MemoryBlockDB memoryBlockDB = newBlock;
                return memoryBlockDB;
            }
            catch (IOException e) {
                this.program.dbError(e);
                MemoryBlock memoryBlock = null;
                this.lock.release();
                return memoryBlock;
            }
        }
        finally {
            this.lock.release();
        }
    }

    private void checkFileBytesRange(FileBytes fileBytes, long offset, long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("Length must be > 0, got " + length);
        }
        if (offset < 0L || offset >= fileBytes.getSize()) {
            long limit = fileBytes.getSize() - 1L;
            throw new IndexOutOfBoundsException("Offset must be in range [0," + limit + "], got " + offset);
        }
        if (offset + length > fileBytes.getSize()) {
            throw new IndexOutOfBoundsException("Specified length extends beyond file bytes length");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock createUninitializedBlock(String name, Address start, long size, boolean overlay) throws MemoryConflictException, AddressOverflowException, LockException, DuplicateNameException {
        Objects.requireNonNull(name);
        this.lock.acquire();
        try {
            this.checkBlockSize(size, false);
            this.program.checkExclusiveAccess();
            if (overlay) {
                start = this.createOverlaySpace(name, start, size);
            } else {
                this.checkRange(start, size);
            }
            try {
                MemoryBlockDB newBlock = this.adapter.createBlock(MemoryBlockType.DEFAULT, name, start, size, null, false, 4);
                this.initializeBlocks();
                this.addBlockAddresses(newBlock);
                this.fireBlockAdded(newBlock);
                MemoryBlockDB memoryBlockDB = newBlock;
                return memoryBlockDB;
            }
            catch (IOException e) {
                this.program.dbError(e);
                this.lock.release();
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock createBitMappedBlock(String name, Address start, Address overlayAddress, long length) throws MemoryConflictException, AddressOverflowException, LockException {
        Objects.requireNonNull(name);
        this.lock.acquire();
        try {
            this.checkBlockSize(length, false);
            this.program.checkExclusiveAccess();
            this.checkRange(start, length);
            overlayAddress.addNoWrap((length - 1L) / 8L);
            try {
                MemoryBlockDB newBlock = this.adapter.createBlock(MemoryBlockType.BIT_MAPPED, name, start, length, overlayAddress, false, 4);
                this.initializeBlocks();
                this.addBlockAddresses(newBlock);
                this.fireBlockAdded(newBlock);
                MemoryBlockDB memoryBlockDB = newBlock;
                return memoryBlockDB;
            }
            catch (IOException e) {
                this.program.dbError(e);
                this.lock.release();
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock createByteMappedBlock(String name, Address start, Address overlayAddress, long length) throws MemoryConflictException, AddressOverflowException, LockException {
        Objects.requireNonNull(name);
        this.lock.acquire();
        try {
            this.checkBlockSize(length, false);
            this.program.checkExclusiveAccess();
            this.checkRange(start, length);
            overlayAddress.addNoWrap(length - 1L);
            try {
                MemoryBlockDB newBlock = this.adapter.createBlock(MemoryBlockType.BYTE_MAPPED, name, start, length, overlayAddress, false, 4);
                this.initializeBlocks();
                this.addBlockAddresses(newBlock);
                this.fireBlockAdded(newBlock);
                MemoryBlockDB memoryBlockDB = newBlock;
                return memoryBlockDB;
            }
            catch (IOException e) {
                this.program.dbError(e);
                this.lock.release();
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock createBlock(MemoryBlock block, String name, Address start, long length) throws MemoryConflictException, AddressOverflowException, LockException {
        Objects.requireNonNull(name);
        this.lock.acquire();
        try {
            this.checkBlockSize(length, block.isInitialized());
            this.program.checkExclusiveAccess();
            this.checkRange(start, length);
            try {
                Address overlayAddr = null;
                if (block.isMapped()) {
                    MemoryBlockSourceInfo info = block.getSourceInfos().get(0);
                    overlayAddr = info.getMappedRange().get().getMinAddress();
                }
                MemoryBlockDB newBlock = this.adapter.createBlock(block.getType(), name, start, length, overlayAddr, block.isInitialized(), block.getPermissions());
                this.initializeBlocks();
                this.addBlockAddresses(newBlock);
                this.fireBlockAdded(newBlock);
                MemoryBlockDB memoryBlockDB = newBlock;
                return memoryBlockDB;
            }
            catch (IOException e) {
                this.program.dbError(e);
                MemoryBlock memoryBlock = null;
                this.lock.release();
                return memoryBlock;
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public long getSize() {
        return this.addrSet.getNumAddresses();
    }

    @Override
    public MemoryBlock[] getBlocks() {
        this.lock.acquire();
        try {
            MemoryBlock[] memoryBlockArray = this.blocks.toArray(new MemoryBlock[this.blocks.size()]);
            return memoryBlockArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveBlock(MemoryBlock block, Address newStartAddr, TaskMonitor monitor) throws MemoryBlockException, MemoryConflictException, AddressOverflowException, NotFoundException, LockException {
        this.lock.acquire();
        try {
            this.program.checkExclusiveAccess();
            if (this.liveMemory != null) {
                throw new MemoryBlockException("Memory move operation not permitted while live memory is active");
            }
            this.checkBlock(block);
            MemoryBlockDB memBlock = (MemoryBlockDB)block;
            Address oldStartAddr = block.getStart();
            if (block.getType() == MemoryBlockType.OVERLAY) {
                throw new IllegalArgumentException("Overlay blocks cannot be moved");
            }
            if (newStartAddr.getAddressSpace().isOverlaySpace()) {
                throw new IllegalArgumentException("Can not move a block into an overlay space.");
            }
            this.program.setEventsEnabled(false);
            try {
                Address newEndAddr = newStartAddr.addNoWrap(block.getSize() - 1L);
                AddressSet set = new AddressSet(this.addrSet);
                set.deleteRange(block.getStart(), block.getEnd());
                if (set.intersects(newStartAddr, newEndAddr)) {
                    throw new MemoryConflictException("Block move conflicts with other existing memory block");
                }
                try {
                    memBlock.setStartAddress(newStartAddr);
                    this.reloadAll();
                }
                catch (IOException e) {
                    this.program.dbError(e);
                }
                this.program.moveAddressRange(oldStartAddr, newStartAddr, memBlock.getSize(), monitor);
            }
            finally {
                this.program.invalidate();
                this.program.setEventsEnabled(true);
            }
            this.fireBlockMoved(memBlock, oldStartAddr);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void split(MemoryBlock block, Address addr) throws MemoryBlockException, NotFoundException, LockException {
        this.lock.acquire();
        try {
            this.program.checkExclusiveAccess();
            if (this.liveMemory != null) {
                throw new MemoryBlockException("Memory split operation not permitted while live memory is active");
            }
            this.checkBlock(block);
            MemoryBlockDB memBlock = (MemoryBlockDB)block;
            if (!memBlock.contains(addr)) {
                throw new IllegalArgumentException("Block must contain split address");
            }
            if (addr.equals(memBlock.getStart())) {
                throw new IllegalArgumentException("Split cannot be done on block start address");
            }
            if (memBlock.getType() == MemoryBlockType.OVERLAY) {
                throw new IllegalArgumentException("Split cannot be done on an overlay block");
            }
            if (memBlock.getType() == MemoryBlockType.BIT_MAPPED) {
                throw new IllegalArgumentException("Split cannot be done on a bit mapped block");
            }
            try {
                memBlock.split(addr);
                this.initializeBlocks();
                this.fireBlockSplit();
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock join(MemoryBlock blockOne, MemoryBlock blockTwo) throws MemoryBlockException, NotFoundException, LockException {
        this.lock.acquire();
        try {
            if (blockOne.getStart().compareTo(blockTwo.getStart()) > 0) {
                MemoryBlock tmp = blockOne;
                blockOne = blockTwo;
                blockTwo = tmp;
            }
            this.checkPreconditionsForJoining(blockOne, blockTwo);
            MemoryBlockDB memBlock1 = (MemoryBlockDB)blockOne;
            MemoryBlockDB memBlock2 = (MemoryBlockDB)blockTwo;
            Address block1Addr = blockOne.getStart();
            Address block2Addr = blockTwo.getStart();
            MemoryBlock newBlock = null;
            try {
                memBlock1.join(memBlock2);
                this.reloadAll();
                newBlock = this.getBlockDB(block1Addr);
                this.fireBlocksJoined(newBlock, block2Addr);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            MemoryBlock memoryBlock = newBlock;
            return memoryBlock;
        }
        finally {
            this.lock.release();
        }
    }

    private void checkPreconditionsForJoining(MemoryBlock block1, MemoryBlock block2) throws MemoryBlockException, NotFoundException, LockException {
        this.program.checkExclusiveAccess();
        if (this.liveMemory != null) {
            throw new MemoryBlockException("Memory join operation not permitted while live memory is active");
        }
        this.checkBlockForJoining(block1);
        this.checkBlockForJoining(block2);
        if (block1.isInitialized() != block2.isInitialized()) {
            throw new MemoryBlockException("Both blocks must be either initialized or uninitialized");
        }
        if (!block1.getEnd().isSuccessor(block2.getStart())) {
            throw new MemoryBlockException("Blocks are not contiguous");
        }
    }

    private void checkBlockForJoining(MemoryBlock block) {
        this.checkBlock(block);
        switch (block.getType()) {
            case BIT_MAPPED: {
                throw new IllegalArgumentException("Cannot join bit mapped blocks");
            }
            case BYTE_MAPPED: {
                throw new IllegalArgumentException("Cannot join byte mapped blocks");
            }
            case OVERLAY: {
                throw new IllegalArgumentException("Cannot join overlay blocks");
            }
        }
    }

    private void checkBlock(MemoryBlock block) {
        if (!(block instanceof MemoryBlockDB)) {
            throw new IllegalArgumentException("Blocks do not belong to this program");
        }
        MemoryBlockDB blockDB = (MemoryBlockDB)block;
        if (blockDB.memMap != this) {
            throw new IllegalArgumentException("Blocks do not belong to this program");
        }
        blockDB.checkValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock convertToInitialized(MemoryBlock unitializedBlock, byte initialValue) throws MemoryBlockException, NotFoundException, LockException {
        this.lock.acquire();
        try {
            this.checkBlock(unitializedBlock);
            this.program.checkExclusiveAccess();
            if (unitializedBlock.isInitialized()) {
                throw new IllegalArgumentException("Only an Uninitialized Block may be converted to an Initialized Block");
            }
            MemoryBlockType type = unitializedBlock.getType();
            if (type != MemoryBlockType.DEFAULT && type != MemoryBlockType.OVERLAY) {
                throw new IllegalArgumentException("Block is of a type that cannot be initialized");
            }
            long size = unitializedBlock.getSize();
            if (size > 0x400000000L) {
                throw new MemoryBlockException("Block too large to initialize");
            }
            MemoryBlockDB memBlock = (MemoryBlockDB)unitializedBlock;
            try {
                memBlock.initializeBlock(initialValue);
                this.allInitializedAddrSet.addRange(memBlock.getStart(), memBlock.getEnd());
                this.initializedLoadedAddrSet.addRange(memBlock.getStart(), memBlock.getEnd());
                this.fireBlockChanged(memBlock);
                this.fireBytesChanged(memBlock.getStart(), (int)memBlock.getSize());
                MemoryBlockDB memoryBlockDB = memBlock;
                return memoryBlockDB;
            }
            catch (IOException e) {
                this.program.dbError(e);
                MemoryBlock memoryBlock = null;
                this.lock.release();
                return memoryBlock;
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock convertToUninitialized(MemoryBlock initializedBlock) throws MemoryBlockException, NotFoundException, LockException {
        this.lock.acquire();
        try {
            this.program.checkExclusiveAccess();
            this.checkBlock(initializedBlock);
            if (!initializedBlock.isInitialized()) {
                throw new IllegalArgumentException("Only an Initialized Block may be converted to an Uninitialized Block");
            }
            MemoryBlockType type = initializedBlock.getType();
            if (type != MemoryBlockType.DEFAULT && type != MemoryBlockType.OVERLAY) {
                throw new IllegalArgumentException("Block is of a type that cannot be uninitialized");
            }
            MemoryBlockDB memBlock = (MemoryBlockDB)initializedBlock;
            try {
                memBlock.uninitializeBlock();
                this.allInitializedAddrSet.deleteRange(memBlock.getStart(), memBlock.getEnd());
                this.initializedLoadedAddrSet.deleteRange(memBlock.getStart(), memBlock.getEnd());
                this.fireBlockChanged(memBlock);
                this.fireBytesChanged(memBlock.getStart(), (int)memBlock.getSize());
                MemoryBlockDB memoryBlockDB = memBlock;
                return memoryBlockDB;
            }
            catch (IOException e) {
                this.program.dbError(e);
                MemoryBlock memoryBlock = null;
                this.lock.release();
                return memoryBlock;
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address findBytes(Address addr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        if (monitor == null) {
            monitor = TaskMonitorAdapter.DUMMY_MONITOR;
        }
        AddressIterator it = this.initializedLoadedAddrSet.getAddresses(addr, forward);
        byte[] b = new byte[bytes.length];
        if (forward) {
            while (it.hasNext() && !monitor.isCancelled()) {
                Address addr2 = it.next();
                int moffset = this.match(addr2, bytes, masks, b, forward);
                if (moffset < 0) {
                    try {
                        Address jumpAddr = addr2.addNoWrap(-moffset);
                        if (jumpAddr.hasSameAddressSpace(addr2)) {
                            it = this.initializedLoadedAddrSet.getAddresses(jumpAddr, forward);
                        }
                        monitor.incrementProgress((long)(-moffset));
                    }
                    catch (AddressOverflowException addressOverflowException) {}
                    continue;
                }
                if (moffset == 1) {
                    return addr2;
                }
                monitor.incrementProgress((long)moffset);
            }
        } else {
            while (it.hasNext() && !monitor.isCancelled()) {
                Address addr2 = it.next();
                int moffset = this.match(addr2, bytes, masks, b, forward);
                if (moffset == 1) {
                    return addr2;
                }
                monitor.incrementProgress((long)moffset);
            }
        }
        return null;
    }

    @Override
    public Address findBytes(Address startAddr, Address endAddr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        if (monitor == null) {
            monitor = TaskMonitorAdapter.DUMMY_MONITOR;
        }
        AddressIterator it = this.allInitializedAddrSet.getAddresses(startAddr, forward);
        byte[] b = new byte[bytes.length];
        if (forward) {
            while (it.hasNext() && !monitor.isCancelled()) {
                Address addr2 = it.next();
                if (addr2.compareTo(endAddr) > 0) {
                    return null;
                }
                int moffset = this.match(addr2, bytes, masks, b, forward);
                if (moffset < 0) {
                    try {
                        Address jumpAddr = addr2.addNoWrap(-moffset);
                        if (jumpAddr.hasSameAddressSpace(addr2)) {
                            it = this.allInitializedAddrSet.getAddresses(jumpAddr, forward);
                        }
                        monitor.incrementProgress((long)(-moffset));
                    }
                    catch (AddressOverflowException e) {
                        moffset = -moffset;
                        for (int i = 0; i < moffset && it.hasNext(); ++i) {
                            it.next();
                        }
                        monitor.incrementProgress((long)moffset);
                    }
                    continue;
                }
                if (moffset == 1) {
                    return addr2;
                }
                monitor.incrementProgress(1L);
            }
        } else {
            while (it.hasNext() && !monitor.isCancelled()) {
                Address addr2 = it.next();
                if (addr2.compareTo(endAddr) < 0) {
                    return null;
                }
                int moffset = this.match(addr2, bytes, masks, b, forward);
                if (moffset == 1) {
                    return addr2;
                }
                monitor.incrementProgress(1L);
            }
        }
        return null;
    }

    private int match(Address addr, byte[] bytes, byte[] masks, byte[] data, boolean forward) {
        try {
            int i;
            if (this.getBytes(addr, data) < data.length) {
                return 0;
            }
            if (masks == null) {
                if (Arrays.equals(data, bytes)) {
                    return 1;
                }
                if (!forward) {
                    return 0;
                }
                for (int j = 1; j < bytes.length; ++j) {
                    int off;
                    for (off = 0; off < data.length - j && bytes[off] == data[j + off]; ++off) {
                    }
                    if (off + j != data.length) continue;
                    return -j;
                }
                return -bytes.length;
            }
            for (i = 0; i < bytes.length && (data[i] & masks[i]) == (bytes[i] & masks[i]); ++i) {
            }
            if (i == bytes.length) {
                return 1;
            }
            if (!forward) {
                return 0;
            }
            for (int j = 1; j < bytes.length; ++j) {
                int off;
                for (off = 0; off < data.length - j && (bytes[off] & masks[off]) == (data[j + off] & masks[off]); ++off) {
                }
                if (off + j != data.length) continue;
                return -j;
            }
            return -bytes.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(Address addr) throws MemoryAccessException {
        this.lock.acquire();
        try {
            if (this.liveMemory != null) {
                byte by = this.liveMemory.getByte(addr);
                return by;
            }
            MemoryBlock block = this.getBlockDB(addr);
            if (block == null) {
                throw new MemoryAccessException("Address " + addr.toString(true) + " does not exist in memory");
            }
            byte by = block.getByte(addr);
            return by;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getBytes(Address addr, byte[] dest) throws MemoryAccessException {
        return this.getBytes(addr, dest, 0, dest.length);
    }

    @Override
    public int getBytes(Address addr, byte[] dest, int dIndex, int size) throws MemoryAccessException {
        if (this.liveMemory != null) {
            return this.liveMemory.getBytes(addr, dest, dIndex, size);
        }
        int numRead = 0;
        long lastRead = 0L;
        while (numRead < size) {
            try {
                addr = addr.addNoWrap(lastRead);
                MemoryBlock block = this.getBlock(addr);
                if (block == null || !block.isInitialized() && !block.isMapped()) break;
                lastRead = block.getBytes(addr, dest, numRead + dIndex, size - numRead);
                numRead = (int)((long)numRead + lastRead);
            }
            catch (AddressOverflowException e) {
                // empty catch block
                break;
            }
        }
        if (numRead == 0 && size > 0) {
            throw new MemoryAccessException("Unable to read bytes at " + addr.toString(true));
        }
        return numRead;
    }

    @Override
    public short getShort(Address addr) throws MemoryAccessException {
        byte[] byteBuf = new byte[2];
        int n = this.getBytes(addr, byteBuf, 0, 2);
        if (n != 2) {
            throw new MemoryAccessException("Could not get short at " + addr.toString(true));
        }
        return this.defaultEndian.getShort(byteBuf);
    }

    @Override
    public short getShort(Address addr, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[2];
        int n = this.getBytes(addr, byteBuf, 0, 2);
        if (n != 2) {
            throw new MemoryAccessException("Could not get short at " + addr.toString(true));
        }
        if (isBigEndian) {
            return BIG_ENDIAN.getShort(byteBuf);
        }
        return LITTLE_ENDIAN.getShort(byteBuf);
    }

    @Override
    public int getShorts(Address addr, short[] dest) throws MemoryAccessException {
        return this.getShorts(addr, dest, 0, dest.length);
    }

    @Override
    public int getShorts(Address addr, short[] dest, int dIndex, int nElem) throws MemoryAccessException {
        byte[] byteBuf = new byte[2 * nElem];
        int n = this.getBytes(addr, byteBuf, 0, byteBuf.length);
        if (n < 2) {
            throw new MemoryAccessException("Could not read shorts at " + addr.toString(true));
        }
        n /= 2;
        for (int i = 0; i < 2 * n; i += 2) {
            dest[dIndex + i / 2] = this.defaultEndian.getShort(byteBuf, i);
        }
        return n;
    }

    @Override
    public int getShorts(Address addr, short[] dest, int dIndex, int nElem, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[2 * nElem];
        int n = this.getBytes(addr, byteBuf, 0, byteBuf.length);
        if (n < 2) {
            throw new MemoryAccessException("Could not read shorts at " + addr.toString(true));
        }
        n /= 2;
        if (isBigEndian) {
            for (int i = 0; i < 2 * n; i += 2) {
                dest[dIndex + i / 2] = BIG_ENDIAN.getShort(byteBuf, i);
            }
        } else {
            for (int i = 0; i < 2 * n; i += 2) {
                dest[dIndex + i / 2] = LITTLE_ENDIAN.getShort(byteBuf, i);
            }
        }
        return n;
    }

    @Override
    public int getInt(Address addr) throws MemoryAccessException {
        byte[] byteBuf = new byte[4];
        int n = this.getBytes(addr, byteBuf, 0, 4);
        if (n != 4) {
            throw new MemoryAccessException("Could not get int at " + addr.toString(true));
        }
        return this.defaultEndian.getInt(byteBuf);
    }

    @Override
    public int getInt(Address addr, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[4];
        int n = this.getBytes(addr, byteBuf, 0, 4);
        if (n != 4) {
            throw new MemoryAccessException("Could not get int at " + addr.toString(true));
        }
        if (isBigEndian) {
            return BIG_ENDIAN.getInt(byteBuf);
        }
        return LITTLE_ENDIAN.getInt(byteBuf);
    }

    @Override
    public int getInts(Address addr, int[] dest) throws MemoryAccessException {
        return this.getInts(addr, dest, 0, dest.length);
    }

    @Override
    public int getInts(Address addr, int[] dest, int dIndex, int nElem) throws MemoryAccessException {
        byte[] byteBuf = new byte[4 * nElem];
        int n = this.getBytes(addr, byteBuf, 0, byteBuf.length);
        if (n < 4) {
            throw new MemoryAccessException("Could not read ints at " + addr.toString(true));
        }
        n /= 4;
        for (int i = 0; i < 4 * n; i += 4) {
            dest[dIndex + i / 4] = this.defaultEndian.getInt(byteBuf, i);
        }
        return n;
    }

    @Override
    public int getInts(Address addr, int[] dest, int dIndex, int nElem, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[4 * nElem];
        int n = this.getBytes(addr, byteBuf, 0, byteBuf.length);
        if (n < 4) {
            throw new MemoryAccessException("Could not read ints at " + addr.toString(true));
        }
        n /= 4;
        if (isBigEndian) {
            for (int i = 0; i < 4 * n; i += 4) {
                dest[dIndex + i / 4] = BIG_ENDIAN.getInt(byteBuf, i);
            }
        } else {
            for (int i = 0; i < 4 * n; i += 4) {
                dest[dIndex + i / 4] = LITTLE_ENDIAN.getInt(byteBuf, i);
            }
        }
        return n;
    }

    @Override
    public long getLong(Address addr) throws MemoryAccessException {
        byte[] byteBuf = new byte[8];
        int n = this.getBytes(addr, byteBuf, 0, 8);
        if (n != 8) {
            throw new MemoryAccessException("Could not get long at " + addr.toString(true));
        }
        return this.defaultEndian.getLong(byteBuf);
    }

    @Override
    public long getLong(Address addr, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[8];
        int n = this.getBytes(addr, byteBuf, 0, 8);
        if (n != 8) {
            throw new MemoryAccessException("Could not get long at " + addr.toString(true));
        }
        if (isBigEndian) {
            return BIG_ENDIAN.getLong(byteBuf);
        }
        return LITTLE_ENDIAN.getLong(byteBuf);
    }

    @Override
    public int getLongs(Address addr, long[] dest) throws MemoryAccessException {
        return this.getLongs(addr, dest, 0, dest.length);
    }

    @Override
    public int getLongs(Address addr, long[] dest, int dIndex, int nElem) throws MemoryAccessException {
        byte[] byteBuf = new byte[8 * nElem];
        int n = this.getBytes(addr, byteBuf, 0, byteBuf.length);
        if (n < 8) {
            throw new MemoryAccessException("Could not read longs at " + addr.toString(true));
        }
        n /= 8;
        for (int i = 0; i < 8 * n; i += 8) {
            dest[dIndex + i / 8] = this.defaultEndian.getLong(byteBuf, i);
        }
        return n;
    }

    @Override
    public int getLongs(Address addr, long[] dest, int dIndex, int nElem, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[8 * nElem];
        int n = this.getBytes(addr, byteBuf, 0, byteBuf.length);
        if (n < 8) {
            throw new MemoryAccessException("Could not read longs at " + addr.toString(true));
        }
        n /= 8;
        if (isBigEndian) {
            for (int i = 0; i < 8 * n; i += 8) {
                dest[dIndex + i / 8] = BIG_ENDIAN.getLong(byteBuf, i);
            }
        } else {
            for (int i = 0; i < 8 * n; i += 8) {
                dest[dIndex + i / 8] = LITTLE_ENDIAN.getLong(byteBuf, i);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(Address addr, byte value) throws MemoryAccessException {
        if (this.liveMemory != null) {
            this.liveMemory.putByte(addr, value);
            this.fireBytesChanged(addr, 1);
            return;
        }
        this.lock.acquire();
        try {
            MemoryBlock block = this.getBlock(addr);
            if (block == null) {
                throw new MemoryAccessException("Address " + addr.toString(true) + " does not exist in memory");
            }
            block.putByte(addr, value);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setBytes(Address addr, byte[] source) throws MemoryAccessException {
        this.setBytes(addr, source, 0, source.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(Address address, byte[] source, int sIndex, int size) throws MemoryAccessException {
        if (this.liveMemory != null) {
            int cnt = this.liveMemory.putBytes(address, source, sIndex, size);
            this.fireBytesChanged(address, cnt);
            return;
        }
        this.lock.acquire();
        try {
            Address addr = address;
            int n = size;
            while (n > 0) {
                MemoryBlock block = this.getBlock(addr);
                if (block == null) {
                    throw new MemoryAccessException("Address " + addr.toString(true) + " does not exist in memory");
                }
                if ((n = (int)((long)n - (block.getSize() - addr.subtract(block.getStart())))) <= 0) break;
                try {
                    addr = block.getEnd().addNoWrap(1L);
                }
                catch (AddressOverflowException e) {
                    throw new MemoryAccessException("Attempted to write beyond address space");
                }
            }
            addr = address;
            n = size;
            int offset = sIndex;
            while (n > 0) {
                MemoryBlock block = this.getBlock(addr);
                int cnt = block.putBytes(addr, source, offset, n);
                offset += cnt;
                if ((n -= cnt) <= 0) {
                    break;
                }
                addr = block.getEnd().add(1L);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setShort(Address addr, short value) throws MemoryAccessException {
        byte[] byteBuf = new byte[2];
        this.defaultEndian.getBytes(value, byteBuf);
        this.setBytes(addr, byteBuf, 0, 2);
    }

    @Override
    public void setShort(Address addr, short value, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[2];
        if (isBigEndian) {
            BIG_ENDIAN.getBytes(value, byteBuf);
        } else {
            LITTLE_ENDIAN.getBytes(value, byteBuf);
        }
        this.setBytes(addr, byteBuf, 0, 2);
    }

    @Override
    public void setInt(Address addr, int value) throws MemoryAccessException {
        byte[] byteBuf = new byte[4];
        this.defaultEndian.getBytes(value, byteBuf);
        this.setBytes(addr, byteBuf, 0, 4);
    }

    @Override
    public void setInt(Address addr, int value, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[4];
        if (isBigEndian) {
            BIG_ENDIAN.getBytes(value, byteBuf);
        } else {
            LITTLE_ENDIAN.getBytes(value, byteBuf);
        }
        this.setBytes(addr, byteBuf, 0, 4);
    }

    @Override
    public void setLong(Address addr, long value) throws MemoryAccessException {
        byte[] byteBuf = new byte[8];
        this.defaultEndian.getBytes(value, byteBuf);
        this.setBytes(addr, byteBuf, 0, 8);
    }

    @Override
    public void setLong(Address addr, long value, boolean isBigEndian) throws MemoryAccessException {
        byte[] byteBuf = new byte[8];
        if (isBigEndian) {
            BIG_ENDIAN.getBytes(value, byteBuf);
        } else {
            LITTLE_ENDIAN.getBytes(value, byteBuf);
        }
        this.setBytes(addr, byteBuf, 0, 8);
    }

    @Override
    public boolean contains(Address addr) {
        return this.addrSet.contains(addr);
    }

    @Override
    public boolean contains(Address start, Address end) {
        return this.addrSet.contains(start, end);
    }

    @Override
    public boolean contains(AddressSetView set) {
        return this.addrSet.contains(set);
    }

    @Override
    public boolean isEmpty() {
        return this.addrSet.isEmpty();
    }

    @Override
    public Address getMinAddress() {
        return this.addrSet.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        return this.addrSet.getMaxAddress();
    }

    @Override
    public int getNumAddressRanges() {
        return this.addrSet.getNumAddressRanges();
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return this.addrSet.getAddressRanges();
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean startAtFront) {
        return this.addrSet.getAddressRanges(startAtFront);
    }

    @Override
    public long getNumAddresses() {
        return this.addrSet.getNumAddresses();
    }

    @Override
    public AddressIterator getAddresses(boolean forward) {
        return this.addrSet.getAddresses(forward);
    }

    @Override
    public AddressIterator getAddresses(Address start, boolean forward) {
        return this.addrSet.getAddresses(start, forward);
    }

    @Override
    public boolean intersects(AddressSetView set) {
        return this.addrSet.intersects(set);
    }

    @Override
    public boolean intersects(Address start, Address end) {
        return this.addrSet.intersects(start, end);
    }

    @Override
    public AddressSet intersect(AddressSetView set) {
        return this.addrSet.intersect(set);
    }

    @Override
    public AddressSet intersectRange(Address start, Address end) {
        return this.addrSet.intersectRange(start, end);
    }

    @Override
    public AddressSet union(AddressSetView set) {
        return this.addrSet.union(set);
    }

    @Override
    public AddressSet subtract(AddressSetView set) {
        return this.addrSet.subtract(set);
    }

    @Override
    public AddressSet xor(AddressSetView set) {
        return this.addrSet.xor(set);
    }

    @Override
    public boolean hasSameAddresses(AddressSetView set) {
        return this.addrSet.hasSameAddresses(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlock(MemoryBlock block, TaskMonitor monitor) throws LockException {
        this.lock.acquire();
        try {
            this.program.checkExclusiveAccess();
            this.checkBlock(block);
            MemoryBlockDB memBlock = (MemoryBlockDB)block;
            Address startAddress = block.getStart();
            this.program.setEventsEnabled(false);
            try {
                this.program.deleteAddressRange(startAddress, memBlock.getEnd(), monitor);
                memBlock.delete();
                this.reloadAll();
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            finally {
                this.program.setEventsEnabled(true);
            }
            this.fireBlockRemoved(startAddress);
            if (startAddress.getAddressSpace().isOverlaySpace()) {
                this.checkRemoveAddressSpace(startAddress.getAddressSpace());
            }
        }
        finally {
            this.lock.release();
        }
    }

    private void checkRemoveAddressSpace(AddressSpace addressSpace) {
        this.lock.acquire();
        try {
            this.program.removeOverlaySpace(addressSpace);
        }
        catch (LockException e) {
            throw new AssertException();
        }
        finally {
            this.lock.release();
        }
    }

    private void checkRange(Address start, long size) throws MemoryConflictException, AddressOverflowException {
        Address imageBase;
        AddressSpace space = start.getAddressSpace();
        if (!space.isMemorySpace()) {
            throw new IllegalArgumentException("Invalid memory address for block: " + start.toString(true));
        }
        AddressSpace mySpace = this.addrMap.getAddressFactory().getAddressSpace(space.getName());
        if (mySpace == null || !mySpace.equals(space)) {
            throw new IllegalArgumentException("Block may not be created with unrecognized address space");
        }
        if (space.isOverlaySpace()) {
            throw new IllegalArgumentException("Block may not be created with an Overlay space");
        }
        if (size == 0L) {
            throw new IllegalArgumentException("Block must have a non-zero length");
        }
        Address end = start.addNoWrap(size - 1L);
        if (space == this.program.getAddressFactory().getDefaultAddressSpace() && start.compareTo(imageBase = this.addrMap.getImageBase()) < 0 && end.compareTo(imageBase) >= 0) {
            throw new MemoryConflictException("Block may not span image base address (" + imageBase + ")");
        }
        if (this.addrSet.intersects(start, end)) {
            throw new MemoryConflictException("Part of range (" + start + ", " + end + ") already exists in memory.");
        }
    }

    private AddressSet getMappedIntersection(MemoryBlock block, AddressSet set) {
        AddressSet mappedIntersection = new AddressSet();
        List<MemoryBlockSourceInfo> sourceInfos = block.getSourceInfos();
        MemoryBlockSourceInfo info = sourceInfos.get(0);
        AddressRange range = info.getMappedRange().get();
        AddressSet resolvedIntersection = set.intersect(new AddressSet(range));
        for (AddressRange resolvedRange : resolvedIntersection) {
            mappedIntersection.add(this.getMappedRange(block, resolvedRange));
        }
        return mappedIntersection;
    }

    private AddressRange getMappedRange(MemoryBlock mappedBlock, AddressRange resolvedRange) {
        Address end;
        Address start;
        boolean isBitMapped;
        MemoryBlockSourceInfo info = mappedBlock.getSourceInfos().get(0);
        long startOffset = resolvedRange.getMinAddress().subtract(info.getMappedRange().get().getMinAddress());
        boolean bl = isBitMapped = mappedBlock.getType() == MemoryBlockType.BIT_MAPPED;
        if (isBitMapped) {
            start = mappedBlock.getStart().add(startOffset * 8L);
            end = start.add(resolvedRange.getLength() * 8L - 1L);
        } else {
            start = mappedBlock.getStart().add(startOffset);
            end = start.add(resolvedRange.getLength() - 1L);
        }
        return new AddressRangeImpl(start, end);
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        this.lock.acquire();
        try {
            if (this.blocks == null || this.blocks.isEmpty()) {
                String string = "[empty]\n";
                return string;
            }
            StringBuffer buffer = new StringBuffer();
            for (MemoryBlock memoryBlock : this.blocks) {
                buffer.append("[");
                buffer.append(memoryBlock.getStart());
                buffer.append(", ");
                buffer.append(memoryBlock.getEnd());
                buffer.append("] ");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    public void overlayBlockRenamed(String oldName, String name) throws DuplicateNameException, LockException {
        this.program.renameOverlaySpace(oldName, name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Memory) {
            return obj == this;
        }
        if (obj instanceof AddressSetView) {
            this.lock.acquire();
            try {
                boolean bl = this.addrSet.equals(obj);
                return bl;
            }
            finally {
                this.lock.release();
            }
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public AddressSetView getExecuteSet() {
        AddressSetView set = this.executeSet;
        if (set == null) {
            set = this.computeExecuteSet();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddressSetView computeExecuteSet() {
        this.lock.acquire();
        try {
            AddressSet set = new AddressSet();
            for (MemoryBlock memoryBlock : this.blocks) {
                if (!memoryBlock.isExecute()) continue;
                set.addRange(memoryBlock.getStart(), memoryBlock.getEnd());
            }
            this.executeSet = new AddressSetViewAdapter(set);
            AddressSetView addressSetView = this.executeSet;
            return addressSetView;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void memoryChanged(Address addr, int size) {
        this.fireBytesChanged(addr, size);
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.addrSet.getAddressRanges(start, forward);
    }

    @Override
    public AddressRange getFirstRange() {
        return this.addrSet.getFirstRange();
    }

    @Override
    public AddressRange getLastRange() {
        return this.addrSet.getLastRange();
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        return this.addrSet.getRangeContaining(address);
    }

    @Override
    public Iterator<AddressRange> iterator(boolean forward) {
        return this.addrSet.iterator(forward);
    }

    @Override
    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.addrSet.iterator(start, forward);
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView set) {
        return this.addrSet.findFirstAddressInCommon(set);
    }

    @Override
    public AddressSourceInfo getAddressSourceInfo(Address address) {
        MemoryBlock block = this.getBlock(address);
        if (block != null) {
            return new AddressSourceInfo(this, address, block);
        }
        return null;
    }

    private void checkBlockSize(long newBlockLength, boolean initialized) {
        if (newBlockLength > 0x400000000L) {
            throw new IllegalStateException("New memory block NOT added: exceeds the maximum memory block byte size of 16 GByte(s)");
        }
        long newSize = this.getNumAddresses() + newBlockLength;
        if (newSize < 0L || newSize > 0x400000000L) {
            throw new IllegalStateException("New memory block NOT added: would cause total number of initialized program bytes to exceed the maximum program size of 16 GBytes");
        }
    }

    @Override
    public FileBytes createFileBytes(String filename, long offset, long size, InputStream is, TaskMonitor monitor) throws IOException, CancelledException {
        this.lock.acquire();
        try {
            if (monitor != null && is != null) {
                is = new MonitoredInputStream(is, monitor);
            }
            FileBytes fileBytes = this.fileBytesAdapter.createFileBytes(filename, offset, size, is);
            return fileBytes;
        }
        catch (IOCancelledException e) {
            throw new CancelledException();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public List<FileBytes> getAllFileBytes() {
        List<FileBytes> allFileBytes = this.fileBytesAdapter.getAllFileBytes();
        return Collections.unmodifiableList(allFileBytes);
    }

    private void checkFileBytes(FileBytes fileBytes) {
        if (fileBytes.adapter != this.fileBytesAdapter) {
            throw new IllegalArgumentException("Attempted to delete FileBytes that doesn't belong to this program");
        }
        fileBytes.checkValid();
    }

    @Override
    public boolean deleteFileBytes(FileBytes fileBytes) throws IOException {
        this.lock.acquire();
        try {
            this.checkFileBytes(fileBytes);
            if (this.inUse(fileBytes)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.fileBytesAdapter.deleteFileBytes(fileBytes);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    private boolean inUse(FileBytes fileBytes) {
        for (MemoryBlockDB block : this.blocks) {
            if (!block.uses(fileBytes)) continue;
            return true;
        }
        return false;
    }

    FileBytes getLayeredFileBytes(long fileBytesID) throws IOException {
        List<FileBytes> allFileBytes = this.fileBytesAdapter.getAllFileBytes();
        for (FileBytes layeredFileBytes : allFileBytes) {
            if (layeredFileBytes.getId() != fileBytesID) continue;
            return layeredFileBytes;
        }
        throw new IOException("No File Bytes found for ID: " + fileBytesID);
    }

    List<MemoryBlockDB> getBlocks(Address start, Address end) {
        MemoryBlockDB block;
        ArrayList<MemoryBlockDB> list = new ArrayList<MemoryBlockDB>();
        List<MemoryBlockDB> tmpBlocks = this.blocks;
        int index = Collections.binarySearch(tmpBlocks, start, BLOCK_ADDRESS_COMPARATOR);
        if (index < 0) {
            index = -index - 2;
        }
        if (index >= 0 && (block = tmpBlocks.get(index)).contains(start)) {
            list.add(block);
        }
        while (++index < tmpBlocks.size() && (block = tmpBlocks.get(index)).getStart().compareTo(end) <= 0) {
            list.add(block);
        }
        return list;
    }

    void checkRangeForInstructions(Address start, Address end) throws MemoryAccessException {
        CodeManager codeManager = this.program.getCodeManager();
        Instruction instr = codeManager.getInstructionContaining(start);
        if (instr != null) {
            throw new MemoryAccessException("Memory change conflicts with instruction at " + instr.getMinAddress());
        }
        if (!end.equals(start) && (instr = codeManager.getInstructionAfter(start)) != null && instr.getMinAddress().compareTo(end) <= 0) {
            throw new MemoryAccessException("Memory change conflicts with instruction at " + instr.getMinAddress());
        }
    }
}

