/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.function.VariableDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.model.listing.LocalVariable;

public class LocalVariableDB
extends VariableDB
implements LocalVariable {
    LocalVariableDB(FunctionDB function, SymbolDB symbol) {
        super(function, symbol);
    }

    @Override
    public int getFirstUseOffset() {
        return this.symbol.getFirstUseOffset();
    }

    @Override
    public boolean setFirstUseOffset(int firstUseOffset) {
        this.functionMgr.lock.acquire();
        try {
            this.function.startUpdate();
            this.function.checkDeleted();
            this.symbol.setFirstUseOffset(firstUseOffset);
            this.functionMgr.functionChanged(this.function, 0);
        }
        finally {
            this.function.endUpdate();
            this.functionMgr.lock.release();
        }
        return true;
    }
}

