/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.opcodes;

public enum OpCode {
    DO_NOT_USE_ME_I_AM_ENUM_ELEMENT_ZERO,
    CPUI_COPY,
    CPUI_LOAD,
    CPUI_STORE,
    CPUI_BRANCH,
    CPUI_CBRANCH,
    CPUI_BRANCHIND,
    CPUI_CALL,
    CPUI_CALLIND,
    CPUI_CALLOTHER,
    CPUI_RETURN,
    CPUI_INT_EQUAL,
    CPUI_INT_NOTEQUAL,
    CPUI_INT_SLESS,
    CPUI_INT_SLESSEQUAL,
    CPUI_INT_LESS,
    CPUI_INT_LESSEQUAL,
    CPUI_INT_ZEXT,
    CPUI_INT_SEXT,
    CPUI_INT_ADD,
    CPUI_INT_SUB,
    CPUI_INT_CARRY,
    CPUI_INT_SCARRY,
    CPUI_INT_SBORROW,
    CPUI_INT_2COMP,
    CPUI_INT_NEGATE,
    CPUI_INT_XOR,
    CPUI_INT_AND,
    CPUI_INT_OR,
    CPUI_INT_LEFT,
    CPUI_INT_RIGHT,
    CPUI_INT_SRIGHT,
    CPUI_INT_MULT,
    CPUI_INT_DIV,
    CPUI_INT_SDIV,
    CPUI_INT_REM,
    CPUI_INT_SREM,
    CPUI_BOOL_NEGATE,
    CPUI_BOOL_XOR,
    CPUI_BOOL_AND,
    CPUI_BOOL_OR,
    CPUI_FLOAT_EQUAL,
    CPUI_FLOAT_NOTEQUAL,
    CPUI_FLOAT_LESS,
    CPUI_FLOAT_LESSEQUAL,
    CPUI_UNUSED1,
    CPUI_FLOAT_NAN,
    CPUI_FLOAT_ADD,
    CPUI_FLOAT_DIV,
    CPUI_FLOAT_MULT,
    CPUI_FLOAT_SUB,
    CPUI_FLOAT_NEG,
    CPUI_FLOAT_ABS,
    CPUI_FLOAT_SQRT,
    CPUI_FLOAT_INT2FLOAT,
    CPUI_FLOAT_FLOAT2FLOAT,
    CPUI_FLOAT_TRUNC,
    CPUI_FLOAT_CEIL,
    CPUI_FLOAT_FLOOR,
    CPUI_FLOAT_ROUND,
    CPUI_MULTIEQUAL,
    CPUI_INDIRECT,
    CPUI_PIECE,
    CPUI_SUBPIECE,
    CPUI_CAST,
    CPUI_PTRADD,
    CPUI_PTRSUB,
    CPUI_SEGMENTOP,
    CPUI_CPOOLREF,
    CPUI_NEW,
    CPUI_MAX;

    static final String[] opcode_name;
    static final int[] opcode_indices;

    public String getName() {
        return OpCode.get_opname(this);
    }

    public OpCode getOpCodeFlip() {
        switch (this) {
            case CPUI_INT_EQUAL: {
                return CPUI_INT_NOTEQUAL;
            }
            case CPUI_INT_NOTEQUAL: {
                return CPUI_INT_EQUAL;
            }
            case CPUI_INT_SLESS: {
                return CPUI_INT_SLESSEQUAL;
            }
            case CPUI_INT_SLESSEQUAL: {
                return CPUI_INT_SLESS;
            }
            case CPUI_INT_LESS: {
                return CPUI_INT_LESSEQUAL;
            }
            case CPUI_INT_LESSEQUAL: {
                return CPUI_INT_LESS;
            }
            case CPUI_BOOL_NEGATE: {
                return CPUI_COPY;
            }
            case CPUI_FLOAT_EQUAL: {
                return CPUI_FLOAT_NOTEQUAL;
            }
            case CPUI_FLOAT_NOTEQUAL: {
                return CPUI_FLOAT_EQUAL;
            }
            case CPUI_FLOAT_LESS: {
                return CPUI_FLOAT_LESSEQUAL;
            }
            case CPUI_FLOAT_LESSEQUAL: {
                return CPUI_FLOAT_LESS;
            }
        }
        return CPUI_MAX;
    }

    public boolean getBooleanFlip() {
        switch (this) {
            case CPUI_INT_EQUAL: {
                return false;
            }
            case CPUI_INT_NOTEQUAL: {
                return false;
            }
            case CPUI_INT_SLESS: {
                return true;
            }
            case CPUI_INT_SLESSEQUAL: {
                return true;
            }
            case CPUI_INT_LESS: {
                return true;
            }
            case CPUI_INT_LESSEQUAL: {
                return true;
            }
            case CPUI_BOOL_NEGATE: {
                return false;
            }
            case CPUI_FLOAT_EQUAL: {
                return false;
            }
            case CPUI_FLOAT_NOTEQUAL: {
                return false;
            }
            case CPUI_FLOAT_LESS: {
                return true;
            }
            case CPUI_FLOAT_LESSEQUAL: {
                return true;
            }
        }
        return false;
    }

    public static String get_opname(OpCode op) {
        return opcode_name[op.ordinal()];
    }

    public static OpCode get_opcode(String nm) {
        int min = 1;
        int max = CPUI_MAX.ordinal() - 1;
        while (min <= max) {
            int cur = (min + max) / 2;
            int ind = opcode_indices[cur];
            int result = opcode_name[ind].compareTo(nm);
            if (result < 0) {
                min = cur + 1;
                continue;
            }
            if (result > 0) {
                max = cur - 1;
                continue;
            }
            return OpCode.values()[ind];
        }
        return null;
    }

    static {
        opcode_name = new String[]{"BLANK", "COPY", "LOAD", "STORE", "BRANCH", "CBRANCH", "BRANCHIND", "CALL", "CALLIND", "CALLOTHER", "RETURN", "INT_EQUAL", "INT_NOTEQUAL", "INT_SLESS", "INT_SLESSEQUAL", "INT_LESS", "INT_LESSEQUAL", "INT_ZEXT", "INT_SEXT", "INT_ADD", "INT_SUB", "INT_CARRY", "INT_SCARRY", "INT_SBORROW", "INT_2COMP", "INT_NEGATE", "INT_XOR", "INT_AND", "INT_OR", "INT_LEFT", "INT_RIGHT", "INT_SRIGHT", "INT_MULT", "INT_DIV", "INT_SDIV", "INT_REM", "INT_SREM", "BOOL_NEGATE", "BOOL_XOR", "BOOL_AND", "BOOL_OR", "FLOAT_EQUAL", "FLOAT_NOTEQUAL", "FLOAT_LESS", "FLOAT_LESSEQUAL", "UNUSED1", "FLOAT_NAN", "FLOAT_ADD", "FLOAT_DIV", "FLOAT_MULT", "FLOAT_SUB", "FLOAT_NEG", "FLOAT_ABS", "FLOAT_SQRT", "INT2FLOAT", "FLOAT2FLOAT", "TRUNC", "CEIL", "FLOOR", "ROUND", "BUILD", "DELAY_SLOT", "PIECE", "SUBPIECE", "CAST", "LABEL", "CROSSBUILD", "SEGMENTOP", "CPOOLREF", "NEW"};
        opcode_indices = new int[]{0, 39, 37, 40, 38, 4, 6, 60, 7, 8, 9, 64, 5, 57, 1, 68, 66, 61, 55, 52, 47, 48, 41, 43, 44, 49, 46, 51, 42, 53, 50, 58, 54, 24, 19, 27, 21, 33, 11, 29, 15, 16, 32, 25, 12, 28, 35, 30, 23, 22, 34, 18, 13, 14, 36, 31, 20, 26, 17, 65, 2, 69, 62, 10, 59, 67, 3, 63, 56, 45};
    }
}

