/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.globalcontext;

import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.globalcontext.ContextDatabase;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.utils.MutableLong;
import ghidra.pcodeCPort.utils.Utils;

public class ContextCache {
    private ContextDatabase database = null;
    private boolean allowset;
    private AddrSpace curspace = null;
    private long first;
    private long last;
    private int[] context;

    public void allowSet(boolean val) {
        this.allowset = val;
    }

    public ContextCache(ContextDatabase db) {
        this.database = db;
        this.curspace = null;
        this.allowset = true;
    }

    public void dispose() {
    }

    public ContextDatabase getDatabase() {
        return this.database;
    }

    public void getContext(Address addr, int[] buf) {
        if (!addr.getSpace().equals(this.curspace) || Utils.unsignedCompare(this.first, addr.getOffset()) > 0 || Utils.unsignedCompare(this.last, addr.getOffset()) < 0) {
            this.curspace = addr.getSpace();
            MutableLong firstMutable = new MutableLong(this.first);
            MutableLong lastMutable = new MutableLong(this.last);
            this.context = this.database.getContext(addr, firstMutable, lastMutable);
            this.first = firstMutable.get();
            this.last = lastMutable.get();
        }
        for (int i = 0; i < this.database.getContextSize(); ++i) {
            buf[i] = this.context[i];
        }
    }

    public void setContext(Address addr, int num, int mask, int value) {
        if (!this.allowset) {
            return;
        }
        this.database.setContextRange(addr, num, mask, value);
        if (addr.getSpace().equals(this.curspace) && Utils.unsignedCompare(this.first, addr.getOffset()) <= 0 && Utils.unsignedCompare(this.last, addr.getOffset()) >= 0) {
            this.curspace = null;
        }
    }
}

