/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import java.math.BigInteger;

public class OpBehaviorIntScarry
extends BinaryOpBehavior {
    public OpBehaviorIntScarry() {
        super(22);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        long res = in1 + in2;
        int a = (int)(in1 >> sizein * 8 - 1) & 1;
        int b = (int)(in2 >> sizein * 8 - 1) & 1;
        int r = (int)(res >> sizein * 8 - 1) & 1;
        r ^= a;
        a ^= b;
        return r &= (a ^= 1);
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        BigInteger res = in1.add(in2);
        boolean a = in1.testBit(sizein * 8 - 1);
        boolean b = in2.testBit(sizein * 8 - 1);
        boolean r = res.testBit(sizein * 8 - 1);
        r ^= a;
        a ^= b;
        return (r &= (a ^= true)) ? BigInteger.ONE : BigInteger.ZERO;
    }
}

