/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolTable;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class VarnodeListSymbol
extends ValueSymbol {
    private VarnodeSymbol[] varnode_table;
    private boolean tableisfilled;

    public Collection<VarnodeSymbol> getVarnodeTable() {
        return Collections.unmodifiableList(Arrays.asList(this.varnode_table));
    }

    private void checkTableFill() {
        long min = this.getPatternValue().minValue();
        long max = this.getPatternValue().maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.varnode_table.length;
        for (int i = 0; i < this.varnode_table.length; ++i) {
            if (this.varnode_table[i] != null) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        long ind;
        if (!(this.tableisfilled || (ind = this.getPatternValue().getValue(walker)) >= 0L && ind < (long)this.varnode_table.length && this.varnode_table[(int)ind] != null)) {
            String errmsg = "Failed to resolve varnode <" + this.getName() + ">, index=" + ind;
            if (debug != null) {
                debug.append(errmsg + "\n");
            }
            throw new UnknownInstructionException(errmsg);
        }
        return null;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        VarnodeSymbol vnsym = this.varnode_table[ind];
        VarnodeData fix = vnsym.getFixedVarnode();
        hand.space = fix.space;
        hand.offset_space = null;
        hand.offset_offset = fix.offset;
        hand.size = fix.size;
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        return this.varnode_table[ind].getName();
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) {
        XmlElement el = parser.start(new String[]{"varlist_sym"});
        this.patval = (PatternValue)PatternExpression.restoreExpression(parser, sleigh);
        ArrayList<VarnodeSymbol> varnodes = new ArrayList<VarnodeSymbol>();
        SymbolTable symtab = sleigh.getSymbolTable();
        while (!parser.peek().isEnd()) {
            XmlElement subel = parser.start(new String[0]);
            if (subel.getName().equals("var")) {
                int id = SpecXmlUtils.decodeInt((String)subel.getAttribute("id"));
                varnodes.add((VarnodeSymbol)symtab.findSymbol(id));
            } else {
                varnodes.add(null);
            }
            parser.end(subel);
        }
        this.varnode_table = new VarnodeSymbol[varnodes.size()];
        for (int i = 0; i < this.varnode_table.length; ++i) {
            this.varnode_table[i] = (VarnodeSymbol)varnodes.get(i);
        }
        this.checkTableFill();
        parser.end(el);
    }
}

