/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DecisionNode {
    private DisjointPattern[] patternlist;
    private Constructor[] constructlist;
    private DecisionNode[] children;
    private boolean contextdecision;
    private int startbit;
    private int bitsize;
    private List<DisjointPattern> unmodifiablePatternList;
    private List<Constructor> unmodifiableConstructorList;
    private List<DecisionNode> unmodifiableChildren;
    private static final Comparator<Constructor> debugInstructionComparator = new Comparator<Constructor>(){

        @Override
        public int compare(Constructor c1, Constructor c2) {
            return c1.getLineno() - c2.getLineno();
        }
    };

    public List<DisjointPattern> getPatterns() {
        return this.unmodifiablePatternList;
    }

    public List<Constructor> getConstructors() {
        return this.unmodifiableConstructorList;
    }

    public List<DecisionNode> getChildren() {
        return this.unmodifiableChildren;
    }

    public Constructor resolve(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        int val;
        if (this.bitsize == 0) {
            for (int i = 0; i < this.patternlist.length; ++i) {
                if (debug != null) {
                    debug.append("check pattern[" + (i + 1) + " of " + this.patternlist.length + "]");
                    debug.dumpConstructor(walker.getCurrentSubtableName(), this.constructlist[i]);
                    debug.indent();
                }
                boolean match = this.patternlist[i].isMatch(walker, debug);
                if (debug != null) {
                    debug.dropIndent();
                }
                if (!match) continue;
                return this.constructlist[i];
            }
            if (debug != null) {
                debug.append("Unable to resolve constructor\n");
            }
            throw new UnknownInstructionException("Unable to resolve constructor at " + walker.getAddr());
        }
        if (this.contextdecision) {
            val = walker.getContextBits(this.startbit, this.bitsize);
            this.debugContextBitsDecision(debug, walker, val);
        } else {
            val = walker.getInstructionBits(this.startbit, this.bitsize);
            this.debugInstructionBitsDecision(debug, walker, val);
        }
        Constructor c = this.children[val].resolve(walker, debug);
        return c;
    }

    private void debugContextBitsDecision(SleighDebugLogger debug, ParserWalker walker, int val) {
        if (debug == null || !debug.isVerboseEnabled()) {
            return;
        }
        debug.append("decide on context bits: bitrange=(" + this.startbit + "," + (this.startbit + this.bitsize - 1) + "), value=0x" + Integer.toHexString(val) + ", context=");
        debug.append(walker.getParserContext().getContextBytes(), this.startbit, this.bitsize);
        debug.append("\n");
        this.debugDumpDecendentConstructors(debug, this.children[val]);
    }

    private void debugInstructionBitsDecision(SleighDebugLogger debug, ParserWalker walker, int val) {
        if (debug == null) {
            return;
        }
        int offset = walker.getOffset(-1);
        int mask = -1 << 32 - this.bitsize >>> this.startbit;
        debug.addInstructionPattern(offset, new PatternBlock(0, mask, val));
        if (!debug.isVerboseEnabled()) {
            return;
        }
        MemBuffer memBuf = walker.getParserContext().getMemBuffer();
        int unitSize = memBuf.getAddress().getAddressSpace().getAddressableUnitSize();
        int byteCnt = offset + (this.startbit + this.bitsize + 7) / 8;
        int wordCnt = (byteCnt + unitSize - 1) / unitSize;
        byte[] bytes = new byte[wordCnt * unitSize];
        memBuf.getBytes(bytes, 0);
        debug.append("decide on instruction bits: byte-offset=" + offset + ", bitrange=(" + this.startbit + "," + (this.startbit + this.bitsize - 1) + "), value=0x" + Integer.toHexString(val) + ", bytes=");
        debug.append(bytes, offset * 8 + this.startbit, this.bitsize);
        debug.append("\n");
        this.debugDumpDecendentConstructors(debug, this.children[val]);
    }

    private void debugDumpDecendentConstructors(SleighDebugLogger debug, DecisionNode child) {
        debug.indent();
        debug.append("decendent constructors for decision node (complete tree dump ordered by line number):\n");
        ArrayList<Constructor> clist = new ArrayList<Constructor>();
        child.dumpDecendentConstructors(clist);
        for (Constructor c : clist) {
            debug.dumpConstructor(null, c);
        }
        debug.dropIndent();
    }

    private void dumpDecendentConstructors(List<Constructor> clist) {
        if (this.bitsize == 0) {
            for (Constructor c : this.constructlist) {
                int index = Collections.binarySearch(clist, c, debugInstructionComparator);
                if (index >= 0) continue;
                index = -index - 1;
                clist.add(index, c);
            }
        } else {
            for (DecisionNode child : this.children) {
                child.dumpDecendentConstructors(clist);
            }
        }
    }

    public void restoreXml(XmlPullParser parser, DecisionNode par, SubtableSymbol sub) {
        XmlElement el = parser.start(new String[]{"decision"});
        this.contextdecision = SpecXmlUtils.decodeBoolean((String)el.getAttribute("context"));
        this.startbit = SpecXmlUtils.decodeInt((String)el.getAttribute("start"));
        this.bitsize = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
        ArrayList<DisjointPattern> patlist = new ArrayList<DisjointPattern>();
        ArrayList<Constructor> conlist = new ArrayList<Constructor>();
        ArrayList<DecisionNode> childlist = new ArrayList<DecisionNode>();
        XmlElement subel = parser.peek();
        while (!subel.isEnd()) {
            if (subel.getName().equals("pair")) {
                XmlElement start = parser.start(new String[0]);
                int id = SpecXmlUtils.decodeInt((String)subel.getAttribute("id"));
                conlist.add(sub.getConstructor(id));
                patlist.add(DisjointPattern.restoreDisjoint(parser));
                parser.end(start);
            } else if (subel.getName().equals("decision")) {
                DecisionNode subnode = new DecisionNode();
                subnode.restoreXml(parser, this, sub);
                childlist.add(subnode);
            }
            subel = parser.peek();
        }
        this.patternlist = new DisjointPattern[patlist.size()];
        patlist.toArray(this.patternlist);
        this.constructlist = new Constructor[conlist.size()];
        conlist.toArray(this.constructlist);
        this.children = new DecisionNode[childlist.size()];
        childlist.toArray(this.children);
        parser.end(el);
        this.unmodifiablePatternList = Collections.unmodifiableList(Arrays.asList(this.patternlist));
        this.unmodifiableConstructorList = Collections.unmodifiableList(Arrays.asList(this.constructlist));
        this.unmodifiableChildren = Collections.unmodifiableList(Arrays.asList(this.children));
    }
}

