/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDString;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDReusableName;
import mdemangler.naming.MDSpecialName;
import mdemangler.object.MDObjectCPP;
import mdemangler.template.MDTemplateNameAndArguments;

public class MDBasicName
extends MDParsableItem {
    MDSpecialName specialName;
    MDTemplateNameAndArguments tn;
    MDReusableName reusableName;
    MDObjectCPP embeddedObject;
    MDQualification embeddedObjectQualification;
    String nameModifier = "";

    public MDBasicName(MDMang dmang) {
        super(dmang);
    }

    public void setNameModifier(String nameModifier) {
        this.nameModifier = nameModifier;
    }

    public boolean isConstructor() {
        if (this.specialName != null) {
            return this.specialName.isConstructor();
        }
        if (this.tn != null) {
            return this.tn.isConstructor();
        }
        return false;
    }

    public boolean isDestructor() {
        if (this.specialName != null) {
            return this.specialName.isDestructor();
        }
        if (this.tn != null) {
            return this.tn.isDestructor();
        }
        return false;
    }

    public boolean isTypeCast() {
        if (this.specialName != null) {
            return this.specialName.isTypeCast();
        }
        if (this.tn != null) {
            return this.tn.isTypeCast();
        }
        return false;
    }

    public int getRTTINumber() {
        if (this.specialName != null) {
            return this.specialName.getRTTINumber();
        }
        return -1;
    }

    public boolean isString() {
        if (this.specialName != null) {
            return this.specialName.isString();
        }
        return false;
    }

    public MDString getMDString() {
        if (this.specialName != null && this.specialName.isString()) {
            return this.specialName.getMDString();
        }
        return null;
    }

    public String getName() {
        if (this.specialName != null) {
            return this.specialName.getName();
        }
        if (this.tn != null) {
            return this.tn.getName();
        }
        if (this.reusableName != null) {
            return this.reusableName.getName();
        }
        return "";
    }

    public MDObjectCPP getEmbeddedObject() {
        return this.embeddedObject;
    }

    public void setName(String name) {
        if (this.specialName != null) {
            this.specialName.setName(name);
        } else if (this.tn != null) {
            this.tn.setName(name);
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.reusableName != null) {
            this.reusableName.insert(builder);
        } else if (this.specialName != null) {
            this.specialName.insert(builder);
        } else if (this.embeddedObject != null) {
            this.embeddedObject.insert(builder);
        } else {
            this.tn.insert(builder);
        }
        builder.append(this.nameModifier);
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() == '?') {
            if (this.dmang.peek(1) == '$') {
                this.tn = new MDTemplateNameAndArguments(this.dmang);
                this.tn.parse();
            } else if (this.dmang.peek(1) == '?') {
                this.embeddedObject = new MDObjectCPP(this.dmang);
                this.embeddedObject.parse();
                this.embeddedObjectQualification = new MDQualification(this.dmang);
                this.embeddedObjectQualification.parse();
            } else {
                this.dmang.increment();
                this.specialName = new MDSpecialName(this.dmang, 1);
                this.specialName.parse();
            }
        } else {
            this.reusableName = new MDReusableName(this.dmang);
            this.reusableName.parse();
        }
    }
}

