/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQuery;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryHits;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryHitsAdapter;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class JackrabbitIndexSearcher
extends IndexSearcher {
    private final SessionImpl session;
    private final IndexReader reader;

    public JackrabbitIndexSearcher(SessionImpl s, IndexReader r) {
        super(r);
        this.session = s;
        this.reader = r;
    }

    public MultiColumnQueryHits execute(Query query, Sort sort) throws IOException {
        return new QueryHitsAdapter(this.evaluate(query, sort), QueryImpl.DEFAULT_SELECTOR_NAME);
    }

    public QueryHits evaluate(Query query, Sort sort) throws IOException {
        query = query.rewrite(this.reader);
        QueryHits hits = null;
        if (query instanceof JackrabbitQuery) {
            hits = ((JackrabbitQuery)query).execute(this, this.session, sort);
        }
        if (hits == null) {
            hits = new LuceneQueryHits(this.search(query, sort), this.reader);
        }
        return hits;
    }
}

