/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;

/**
 * The <CODE>VariableXRefFieldLocation</CODE> class provides specific information
 * about the variable's cross reference field within a program location.
 */

public class VariableXRefFieldLocation extends VariableLocation {

	/**
	 * Construct a new VariableXRefFieldLocation object.
	 * @param var the variable
	 * @param refAddr the reference address.
	 * @param index the index of the XREF (tells which XREF).
	 * @param charOffset the character position within the XREF.
	 * @param the program of the location
	 */
	public VariableXRefFieldLocation(Program program, Variable var, Address refAddr, int index,
			int charOffset) {

		super(program, var, index, charOffset);
		this.refAddr = refAddr;
	}

	/**
	 * Should only be used by XML restoration.
	 */
	public VariableXRefFieldLocation() {
		super();
	}

	/**
	 * Returns the index of the XREF in the list.
	 */
	public int getIndex() {
		return getColumn();
	}

	/**
	 * Returns the reference address at this location.
	 */
	public Address getReferenceAddress() {
		return refAddr;
	}

	/**
	 * Returns a String representation of this location.
	 */
	@Override
	public String toString() {
		return super.toString() + ", Function Variable XRef =" + refAddr;
	}

}
