/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Register;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.OldLanguage;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.xml.GenericXMLOutputter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class OldLanguageFactory {
    static final Logger log = LogManager.getLogger(OldLanguageFactory.class);
    public static final String OLD_LANGUAGE_FILE_EXT = ".lang";
    private HashMap<LanguageTag, OldLanguage> languageMap = new HashMap();
    private HashMap<LanguageID, OldLanguage> latestVersionMap = new HashMap();
    private static OldLanguageFactory oldLanguageFactory;
    private int badFileCount = 0;

    public static OldLanguageFactory getOldLanguageFactory() {
        if (oldLanguageFactory == null) {
            oldLanguageFactory = new OldLanguageFactory();
        }
        return oldLanguageFactory;
    }

    private OldLanguageFactory() {
        this.initLanguageMap();
    }

    public Language getOldLanguage(LanguageID languageID, int majorVersion) {
        OldLanguage oldLang = this.languageMap.get(new LanguageTag(languageID, majorVersion));
        if (oldLang != null) {
            try {
                oldLang.validate();
                return oldLang;
            }
            catch (Exception e) {
                Msg.error((Object)log, (Object)e.getMessage());
            }
        }
        return null;
    }

    public LanguageDescription getLatestOldLanguage(LanguageID languageID) {
        OldLanguage oldLang = this.latestVersionMap.get(languageID);
        if (oldLang != null) {
            return oldLang.getDescription();
        }
        return null;
    }

    public LanguageDescription[] getLatestOldLanaguageDescriptions() {
        LanguageDescription[] descriptions = new LanguageDescription[this.latestVersionMap.size()];
        int index = 0;
        for (OldLanguage oldLang : this.latestVersionMap.values()) {
            descriptions[index++] = oldLang.getDescription();
        }
        return descriptions;
    }

    int badFileCount() {
        return this.badFileCount;
    }

    int validateAllOldLanguages() {
        int errorCnt = 0;
        for (OldLanguage oldLang : this.languageMap.values()) {
            try {
                oldLang.validate();
            }
            catch (Exception e) {
                Msg.error((Object)log, (Object)("Failed to validate old language: " + oldLang.getDescription() + " (Version " + oldLang.getVersion() + ")"), (Throwable)e);
                ++errorCnt;
            }
        }
        return errorCnt;
    }

    private void initLanguageMap() {
        LanguageService langSvc = DefaultLanguageService.getLanguageService();
        ArrayList<OldLanguage> oldLanguages = new ArrayList<OldLanguage>();
        this.getOldLanguages(oldLanguages);
        for (OldLanguage oldLang : oldLanguages) {
            LanguageDescription oldDescr = oldLang.getDescription();
            try {
                LanguageDescription curDescr = langSvc.getLanguageDescription(oldLang.getLanguageID());
                if (curDescr.getVersion() <= oldDescr.getVersion()) {
                    log.warn("WARNING! Ignoring old language spec, version still exists: " + oldLang);
                    continue;
                }
            }
            catch (LanguageNotFoundException curDescr) {
                // empty catch block
            }
            LanguageTag tag = new LanguageTag(oldLang.getLanguageID(), oldLang.getVersion());
            this.languageMap.put(tag, oldLang);
            OldLanguage latest = this.latestVersionMap.get(oldLang.getLanguageID());
            if (latest != null && latest.getVersion() >= oldLang.getVersion()) continue;
            this.latestVersionMap.put(oldLang.getLanguageID(), oldLang);
        }
    }

    private void getOldLanguages(List<OldLanguage> list) {
        List files = Application.findFilesByExtensionInApplication((String)OLD_LANGUAGE_FILE_EXT);
        for (ResourceFile file : files) {
            try {
                list.add(new OldLanguage(file));
            }
            catch (Exception e) {
                ++this.badFileCount;
                Msg.error((Object)log, (Object)("Failed to parse: " + file), (Throwable)e);
            }
        }
    }

    public static void createOldLanguageFile(Language lang, File file) throws IOException, LanguageNotFoundException {
        LanguageService languageService = DefaultLanguageService.getLanguageService();
        if (lang instanceof OldLanguage) {
            throw new LanguageNotFoundException("Can't create an Old Langauge file from an OldLanguage");
        }
        LanguageDescription languageDescription = languageService.getLanguageDescription(lang.getLanguageID());
        Element root = new Element("language");
        root.setAttribute("version", Integer.toString(lang.getVersion()));
        root.setAttribute("endian", lang.isBigEndian() ? "big" : "little");
        root.addContent((Content)OldLanguageFactory.getDescriptionElement(languageDescription));
        for (CompilerSpecDescription cs : lang.getCompatibleCompilerSpecDescriptions()) {
            Element compilerElement = new Element("compiler");
            compilerElement.setAttribute("name", cs.getCompilerSpecName());
            compilerElement.setAttribute("id", cs.getCompilerSpecID().getIdAsString());
            root.addContent((Content)compilerElement);
        }
        root.addContent((Content)OldLanguageFactory.getSpacesElement(lang));
        root.addContent((Content)OldLanguageFactory.getRegistersElement(lang));
        Document doc = new Document(root);
        FileOutputStream out = new FileOutputStream(file);
        GenericXMLOutputter xml = new GenericXMLOutputter();
        xml.output(doc, (OutputStream)out);
        out.close();
    }

    private static Element getDescriptionElement(LanguageDescription languageDescription) {
        Element descriptionElement = new Element("description");
        Element element = new Element("id");
        element.setText(languageDescription.getLanguageID().getIdAsString());
        descriptionElement.addContent((Content)element);
        String str = languageDescription.getProcessor().toString();
        if (str != null) {
            element = new Element("processor");
            element.setText(str);
            descriptionElement.addContent((Content)element);
        }
        if ((str = languageDescription.getVariant()) != null) {
            element = new Element("variant");
            element.setText(str);
            descriptionElement.addContent((Content)element);
        }
        element = new Element("size");
        element.setText(Integer.toString(languageDescription.getSize()));
        descriptionElement.addContent((Content)element);
        return descriptionElement;
    }

    private static Element getRegistersElement(Language lang) {
        Register[] registers = lang.getRegisters();
        Register contextReg = lang.getContextBaseRegister();
        Element registersElement = new Element("registers");
        if (contextReg != null) {
            Element ctxElement = OldLanguageFactory.getRegisterElement(contextReg);
            int contextBitLength = contextReg.getBitLength();
            for (Register bitReg : contextReg.getChildRegisters()) {
                Element fieldElement = new Element("field");
                fieldElement.setAttribute("name", bitReg.getName());
                int fieldBitLength = bitReg.getBitLength();
                int lsb = bitReg.getLeastSignificatBitInBaseRegister();
                int msb = lsb + fieldBitLength - 1;
                lsb = contextBitLength - msb - 1;
                msb = lsb + fieldBitLength - 1;
                fieldElement.setAttribute("range", lsb + "," + msb);
                ctxElement.addContent((Content)fieldElement);
            }
            registersElement.addContent((Content)ctxElement);
        }
        for (Register reg : registers) {
            if (reg.getBaseRegister().isProcessorContext()) continue;
            Element regElement = OldLanguageFactory.getRegisterElement(reg);
            registersElement.addContent((Content)regElement);
        }
        return registersElement;
    }

    private static Element getRegisterElement(Register reg) {
        Element regElement = new Element(reg.isProcessorContext() ? "context_register" : "register");
        regElement.setAttribute("name", reg.getName());
        Address addr = reg.getAddress();
        if (addr.isRegisterAddress()) {
            regElement.setAttribute("offset", NumericUtilities.toHexString((long)addr.getOffset()));
        } else {
            regElement.setAttribute("address", addr.toString(true));
        }
        regElement.setAttribute("bitsize", Integer.toString(reg.getBitLength()));
        return regElement;
    }

    private static Element getSpacesElement(Language lang) {
        Element spacesElement = new Element("spaces");
        AddressFactory addrFactory = lang.getAddressFactory();
        AddressSpace defSpace = addrFactory.getDefaultAddressSpace();
        block5: for (AddressSpace space : lang.getAddressFactory().getAllAddressSpaces()) {
            Element element;
            if (space instanceof SegmentedAddressSpace) {
                element = new Element("segmented_space");
                element.setAttribute("name", space.getName());
            } else {
                String type;
                switch (space.getType()) {
                    case 2: {
                        type = "code";
                        break;
                    }
                    case 1: {
                        type = "ram";
                        break;
                    }
                    case 4: {
                        type = "register";
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                element = new Element("space");
                element.setAttribute("name", space.getName());
                element.setAttribute("type", type);
                element.setAttribute("size", Integer.toString(space.getSize() / 8));
                int wordsize = space.getAddressableUnitSize();
                if (wordsize != 1) {
                    element.setAttribute("wordsize", Integer.toString(wordsize));
                }
            }
            if (space == defSpace) {
                element.setAttribute("default", "yes");
            }
            spacesElement.addContent((Content)element);
        }
        return spacesElement;
    }

    private static class LanguageTag {
        LanguageID id;
        int version;

        LanguageTag(LanguageID id, int version) {
            this.id = id;
            this.version = version;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LanguageTag)) {
                return false;
            }
            LanguageTag other = (LanguageTag)obj;
            return this.version == other.version && this.id.equals(other.id);
        }

        public int hashCode() {
            return this.id.hashCode() + this.version;
        }
    }
}

