/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.correlate;

import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.correlate.Block;
import ghidra.program.model.correlate.DisambiguateStrategy;
import ghidra.program.model.correlate.Hash;
import ghidra.program.model.correlate.HashStore;
import ghidra.program.model.correlate.InstructHash;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;

public class DisambiguateByParent
implements DisambiguateStrategy {
    private static final int ENTRY_BLOCK_HASH = -1702134675;

    @Override
    public ArrayList<Hash> calcHashes(InstructHash instHash, int matchSize, HashStore store) throws CancelledException {
        ArrayList<Hash> res = new ArrayList<Hash>();
        Block block = instHash.getBlock();
        CodeBlockReferenceIterator iter = block.origBlock.getSources(store.getMonitor());
        int count = 0;
        while (iter.hasNext()) {
            CodeBlockReference ref = iter.next();
            ++count;
            Block srcBlock = store.getBlock(ref.getSourceAddress());
            if (srcBlock == null || srcBlock.getMatchHash() == 0) continue;
            res.add(new Hash(srcBlock.getMatchHash(), 1));
        }
        if (count == 0) {
            res.add(new Hash(-1702134675, 1));
        }
        return res;
    }
}

