/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.code.CodeUnitDB;
import ghidra.program.database.code.DataComponent;
import ghidra.program.database.code.DataDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

class DataDB
extends CodeUnitDB
implements Data {
    protected DataType dataType;
    protected DataType baseDataType;
    protected int level = 0;
    protected DataTypeManagerDB dataMgr;
    protected Settings defaultSettings;
    private Boolean hasMutabilitySetting;
    private static final int[] EMPTY_PATH = new int[0];
    private DBObjectCache<DataDB> componentCache = null;

    DataDB(CodeManager codeMgr, DBObjectCache<? extends CodeUnitDB> codeUnitCache, long cacheKey, Address address, long addr, DataType dataType) {
        super(codeMgr, codeUnitCache, cacheKey, address, addr, dataType == null ? 1 : dataType.getLength());
        if (dataType == null) {
            dataType = DataType.DEFAULT;
        }
        this.dataType = dataType;
        this.dataMgr = this.program.getDataTypeManager();
        this.baseDataType = DataDB.getBaseDataType(dataType);
        this.defaultSettings = dataType.getDefaultSettings();
        this.computeLength();
        if (this.length < 0) {
            Msg.error((Object)this, (Object)" bad bad");
        }
    }

    protected static DataType getBaseDataType(DataType dataType) {
        DataType dt = dataType;
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        return dt;
    }

    @Override
    protected boolean refresh(Record record) {
        if (this.componentCache != null) {
            this.componentCache.invalidate();
        }
        this.hasMutabilitySetting = null;
        return super.refresh(record);
    }

    @Override
    protected boolean hasBeenDeleted(Record rec) {
        DataType dt;
        if (this.dataType == DataType.DEFAULT) {
            return rec != null || !this.codeMgr.isUndefined(this.address, this.addr);
        }
        if (rec != null) {
            if (!rec.hasSameSchema(DataDBAdapter.DATA_SCHEMA)) {
                return true;
            }
            dt = this.codeMgr.getDataType(rec);
            if (dt == null) {
                Msg.error((Object)this, (Object)("Data found but datatype missing at " + this.address));
            }
        } else {
            dt = this.codeMgr.getDataType(this.addr);
        }
        if (dt == null) {
            return true;
        }
        this.dataType = dt;
        this.baseDataType = DataDB.getBaseDataType(this.dataType);
        this.defaultSettings = this.dataType.getDefaultSettings();
        this.computeLength();
        return false;
    }

    private void computeLength() {
        Address nextAddr;
        this.length = this.dataType.getLength();
        if (this.length < 1) {
            this.length = this.codeMgr.getLength(this.address);
        }
        if (this.length < 1) {
            this.length = this.baseDataType instanceof Pointer ? this.address.getPointerSize() : 1;
        }
        if (this.address.isExternalAddress()) {
            return;
        }
        Memory mem = this.program.getMemory();
        Address endAddress = null;
        boolean noEndAddr = false;
        try {
            endAddress = this.address.addNoWrap(this.length - 1);
        }
        catch (AddressOverflowException ex) {
            noEndAddr = true;
        }
        if (noEndAddr || !mem.contains(this.address, endAddress)) {
            MemoryBlock block = mem.getBlock(this.address);
            if (block != null) {
                endAddress = block.getEnd();
                this.length = (int)endAddress.subtract(this.address) + 1;
            } else {
                this.length = 1;
            }
        }
        if ((nextAddr = this.codeMgr.getDefinedAddressAfter(this.address)) != null && nextAddr.compareTo(endAddress) <= 0) {
            this.length = (int)nextAddr.subtract(this.address);
        }
        this.bytes = null;
    }

    @Override
    public void addValueReference(Address refAddr, RefType type) {
        this.refreshIfNeeded();
        this.refMgr.addMemoryReference(this.address, refAddr, type, SourceType.USER_DEFINED, 0);
    }

    @Override
    public void removeValueReference(Address refAddr) {
        this.removeOperandReference(0, refAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data getComponent(int index) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (index < 0 || index >= this.getNumComponents()) {
                Data data = null;
                return data;
            }
            if (this.componentCache == null) {
                this.componentCache = new DBObjectCache(1);
            } else {
                Data data = this.componentCache.get(index);
                if (data != null) {
                    Data data2 = data;
                    return data2;
                }
            }
            AddressMap addressMap = this.codeMgr.getAddressMap();
            if (this.baseDataType instanceof Array) {
                Array array = (Array)this.baseDataType;
                int elementLength = array.getElementLength();
                Address componentAddr = this.address.add(index * elementLength);
                DataComponent dataComponent = new DataComponent(this.codeMgr, this.componentCache, componentAddr, addressMap.getKey(componentAddr, false), this, array.getDataType(), index, index * elementLength, elementLength);
                return dataComponent;
            }
            if (this.baseDataType instanceof Composite) {
                Composite struct = (Composite)this.baseDataType;
                DataTypeComponent dtc = struct.getComponent(index);
                Address componentAddr = this.address.add(dtc.getOffset());
                DataComponent dataComponent = new DataComponent(this.codeMgr, this.componentCache, componentAddr, addressMap.getKey(componentAddr, false), this, dtc);
                return dataComponent;
            }
            if (this.baseDataType instanceof DynamicDataType) {
                DynamicDataType ddt = (DynamicDataType)this.baseDataType;
                DataTypeComponent dtc = ddt.getComponent(index, this);
                Address componentAddr = this.address.add(dtc.getOffset());
                DataComponent dataComponent = new DataComponent(this.codeMgr, this.componentCache, componentAddr, addressMap.getKey(componentAddr, false), this, dtc);
                return dataComponent;
            }
            Msg.error((Object)this, (Object)("Unsupported composite data type class: " + this.baseDataType.getClass().getName()));
            Data data = null;
            return data;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address getAddress(int opIndex) {
        Object obj;
        if (opIndex == 0 && (obj = this.getValue()) instanceof Address) {
            return (Address)obj;
        }
        return null;
    }

    @Override
    public String toString() {
        String valueRepresentation = this.getDefaultValueRepresentation();
        String mnemonicString = this.getMnemonicString();
        if (valueRepresentation == null) {
            return mnemonicString;
        }
        return mnemonicString + " " + valueRepresentation;
    }

    @Override
    public String getDefaultValueRepresentation() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.dataType.getRepresentation(this, this, this.length);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getMnemonicString() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.dataType.getMnemonic(this);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumOperands() {
        return 1;
    }

    @Override
    public Scalar getScalar(int opIndex) {
        if (opIndex == 0) {
            Object obj = this.getValue();
            if (obj instanceof Scalar) {
                return (Scalar)obj;
            }
            if (obj instanceof Address) {
                Address addrObj = (Address)obj;
                long offset = addrObj.getAddressableWordOffset();
                return new Scalar(addrObj.getAddressSpace().getPointerSize() * 8, offset, false);
            }
        }
        return null;
    }

    @Override
    public DataType getBaseDataType() {
        return this.baseDataType;
    }

    private <T extends SettingsDefinition> T getSettingsDefinition(Class<T> settingsDefinitionClass) {
        DataType dt = this.baseDataType;
        for (SettingsDefinition def : dt.getSettingsDefinitions()) {
            if (!settingsDefinitionClass.isAssignableFrom(def.getClass())) continue;
            return (T)((SettingsDefinition)settingsDefinitionClass.cast(def));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMutability(int mutabilityType) {
        Boolean hasSetting = this.hasMutabilitySetting;
        if (hasSetting != null && !hasSetting.booleanValue()) {
            return mutabilityType == 0;
        }
        this.lock.acquire();
        try {
            this.checkIsValid();
            MutabilitySettingsDefinition def = this.getSettingsDefinition(MutabilitySettingsDefinition.class);
            if (def != null) {
                this.hasMutabilitySetting = true;
                boolean bl = def.getChoice(this) == mutabilityType;
                return bl;
            }
            this.hasMutabilitySetting = false;
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    @Override
    public boolean isConstant() {
        return this.hasMutability(2);
    }

    @Override
    public boolean isVolatile() {
        return this.hasMutability(1);
    }

    public void clearSetting(String name) {
        this.refreshIfNeeded();
        Address cuAddr = this.getDataSettingsAddress();
        if (this.dataMgr.clearSetting(cuAddr, name)) {
            this.changeMgr.setChanged(109, cuAddr, cuAddr, null, null);
        }
    }

    public byte[] getByteArray(String name) {
        this.refreshIfNeeded();
        byte[] tempBytes = this.dataMgr.getByteSettingsValue(this.getDataSettingsAddress(), name);
        if (tempBytes == null && this.defaultSettings != null) {
            tempBytes = this.defaultSettings.getByteArray(name);
        }
        return tempBytes;
    }

    public Long getLong(String name) {
        this.refreshIfNeeded();
        Long value = this.dataMgr.getLongSettingsValue(this.getDataSettingsAddress(), name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getLong(name);
        }
        return value;
    }

    public String[] getNames() {
        this.refreshIfNeeded();
        return this.dataMgr.getNames(this.getDataSettingsAddress());
    }

    public String getString(String name) {
        this.refreshIfNeeded();
        String value = this.dataMgr.getStringSettingsValue(this.getDataSettingsAddress(), name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getString(name);
        }
        return value;
    }

    public Object getValue(String name) {
        this.refreshIfNeeded();
        Object value = this.dataMgr.getSettings(this.getDataSettingsAddress(), name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getValue(name);
        }
        return value;
    }

    public void setByteArray(String name, byte[] value) {
        this.refreshIfNeeded();
        Address cuAddr = this.getDataSettingsAddress();
        if (this.dataMgr.setByteSettingsValue(cuAddr, name, value)) {
            this.changeMgr.setChanged(109, cuAddr, cuAddr, null, null);
        }
    }

    public void setLong(String name, long value) {
        this.refreshIfNeeded();
        Address cuAddr = this.getDataSettingsAddress();
        if (this.dataMgr.setLongSettingsValue(cuAddr, name, value)) {
            this.changeMgr.setChanged(109, cuAddr, cuAddr, null, null);
        }
    }

    public void setString(String name, String value) {
        this.refreshIfNeeded();
        Address cuAddr = this.getDataSettingsAddress();
        if (this.dataMgr.setStringSettingsValue(cuAddr, name, value)) {
            this.changeMgr.setChanged(109, cuAddr, cuAddr, null, null);
        }
    }

    public void setValue(String name, Object value) {
        this.refreshIfNeeded();
        Address cuAddr = this.getDataSettingsAddress();
        if (this.dataMgr.setSettings(cuAddr, name, value)) {
            this.changeMgr.setChanged(109, cuAddr, cuAddr, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data getComponent(int[] componentPath) {
        this.lock.acquire();
        try {
            if (componentPath == null || componentPath.length <= this.level) {
                DataDB dataDB = this;
                return dataDB;
            }
            Data component = this.getComponent(componentPath[this.level]);
            Data data = component == null ? null : component.getComponent(componentPath);
            return data;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getComment(int commentType) {
        Data child = this.getComponentAt(0);
        if (child != null) {
            return child.getComment(commentType);
        }
        return super.getComment(commentType);
    }

    @Override
    public void setComment(int commentType, String comment) {
        Data child = this.getComponentAt(0);
        if (child != null) {
            child.setComment(commentType, comment);
        } else {
            super.setComment(commentType, comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data getComponentAt(int offset) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (offset < 0 || offset >= this.length) {
                Data data = null;
                return data;
            }
            if (this.baseDataType instanceof Array) {
                Array array = (Array)this.baseDataType;
                int elementLength = array.getElementLength();
                int index = offset / elementLength;
                Data data = this.getComponent(index);
                return data;
            }
            if (this.baseDataType instanceof Structure) {
                Structure struct = (Structure)this.baseDataType;
                DataTypeComponent dtc = struct.getComponentAt(offset);
                Data data = dtc != null ? this.getComponent(dtc.getOrdinal()) : null;
                return data;
            }
            if (this.baseDataType instanceof DynamicDataType) {
                DynamicDataType ddt = (DynamicDataType)this.baseDataType;
                DataTypeComponent dtc = ddt.getComponentAt(offset, this);
                Data data = dtc != null ? this.getComponent(dtc.getOrdinal()) : null;
                return data;
            }
            if (this.baseDataType instanceof Union) {
                // empty if block
            }
            Data data = null;
            return data;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Data> getComponentsContaining(int offset) {
        ArrayList<Data> list = new ArrayList<Data>();
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (offset < 0 || offset >= this.length) {
                List<Data> list2 = null;
                return list2;
            }
            if (this.baseDataType instanceof Array) {
                Array array = (Array)this.baseDataType;
                int elementLength = array.getElementLength();
                int index = offset / elementLength;
                list.add(this.getComponent(index));
            } else if (this.baseDataType instanceof Structure) {
                Structure struct = (Structure)this.baseDataType;
                DataTypeComponent dtc = struct.getComponentAt(offset);
                while (dtc != null && offset >= dtc.getOffset() && offset <= dtc.getOffset() + dtc.getLength() - 1) {
                    int ordinal = dtc.getOrdinal();
                    list.add(this.getComponent(ordinal++));
                    dtc = ordinal < struct.getNumComponents() ? struct.getComponent(ordinal) : null;
                }
            } else if (this.baseDataType instanceof DynamicDataType) {
                DynamicDataType ddt = (DynamicDataType)this.baseDataType;
                DataTypeComponent dtc = ddt.getComponentAt(offset, this);
                if (dtc != null) {
                    list.add(this.getComponent(dtc.getOrdinal()));
                }
            } else if (this.baseDataType instanceof Union && offset == 0) {
                for (int i = 0; i < this.getNumComponents(); ++i) {
                    list.add(this.getComponent(i));
                }
            }
            ArrayList<Data> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getComponentIndex() {
        return -1;
    }

    @Override
    public int getComponentLevel() {
        return this.level;
    }

    @Override
    public int[] getComponentPath() {
        return EMPTY_PATH;
    }

    @Override
    public String getComponentPathName() {
        return null;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getFieldName() {
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public int getNumComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.length < this.dataType.getLength()) {
                int n = -1;
                return n;
            }
            if (this.baseDataType instanceof Composite) {
                int n = ((Composite)this.baseDataType).getNumComponents();
                return n;
            }
            if (this.baseDataType instanceof Array) {
                int n = ((Array)this.baseDataType).getNumElements();
                return n;
            }
            if (this.baseDataType instanceof DynamicDataType) {
                try {
                    int n = ((DynamicDataType)this.baseDataType).getNumComponents(this);
                    return n;
                }
                catch (Throwable t) {
                    int n = 0;
                    this.lock.release();
                    return n;
                }
            }
            int n = 0;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Data getParent() {
        return null;
    }

    @Override
    public int getParentOffset() {
        return 0;
    }

    @Override
    public String getPathName() {
        this.refreshIfNeeded();
        Address cuAddress = this.address;
        SymbolTable st = this.program.getSymbolTable();
        Symbol symbol = st.getPrimarySymbol(cuAddress);
        if (symbol == null) {
            return SymbolUtilities.getDynamicName(this.program, cuAddress);
        }
        return symbol.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data getPrimitiveAt(int offset) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (offset < 0 || offset >= this.length) {
                Data data = null;
                return data;
            }
            Data dc = this.getComponentAt(offset);
            if (dc == null || dc == this) {
                DataDB dataDB = this;
                return dataDB;
            }
            Data data = dc.getPrimitiveAt(offset - dc.getParentOffset());
            return data;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Data getRoot() {
        return this;
    }

    @Override
    public int getRootOffset() {
        return 0;
    }

    @Override
    public Object getValue() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Object object = this.baseDataType.getValue(this, this, this.length);
            return object;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Class<?> getValueClass() {
        DataType dt = this.getBaseDataType();
        if (dt != null) {
            return dt.getValueClass(this);
        }
        return null;
    }

    @Override
    public boolean hasStringValue() {
        return String.class.equals(this.getValueClass());
    }

    @Override
    public String getDefaultLabelPrefix(DataTypeDisplayOptions options) {
        if (this.dataType == DataType.DEFAULT) {
            return null;
        }
        if (options == null) {
            options = DataTypeDisplayOptions.DEFAULT;
        }
        return this.dataType.getDefaultLabelPrefix(this, this, this.length, options);
    }

    @Override
    public Reference[] getValueReferences() {
        return this.getOperandReferences(0);
    }

    @Override
    public boolean isArray() {
        return this.baseDataType instanceof Array;
    }

    @Override
    public boolean isDefined() {
        return !(this.dataType instanceof DefaultDataType);
    }

    @Override
    public boolean isPointer() {
        return this.baseDataType instanceof Pointer;
    }

    @Override
    public boolean isStructure() {
        return this.baseDataType instanceof Structure;
    }

    @Override
    public boolean isDynamic() {
        return this.baseDataType instanceof DynamicDataType;
    }

    @Override
    public boolean isUnion() {
        return this.baseDataType instanceof Union;
    }

    public void clearAllSettings() {
        this.refreshIfNeeded();
        Address cuAddr = this.getDataSettingsAddress();
        this.dataMgr.clearAllSettings(cuAddr);
        this.changeMgr.setChanged(109, cuAddr, cuAddr, null, null);
    }

    public boolean isEmpty() {
        this.refreshIfNeeded();
        return this.dataMgr.isEmptySetting(this.getDataSettingsAddress());
    }

    @Override
    public Reference[] getReferencesFrom() {
        ArrayList<Reference> list = new ArrayList<Reference>();
        AddressSet set = new AddressSet(this.getMinAddress(), this.getMaxAddress());
        AddressIterator iter = this.refMgr.getReferenceSourceIterator(set, true);
        while (iter.hasNext()) {
            Reference[] refs;
            Address fromAddress = iter.next();
            for (Reference element : refs = this.refMgr.getReferencesFrom(fromAddress)) {
                list.add(element);
            }
        }
        return list.toArray(new Reference[list.size()]);
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    protected Address getDataSettingsAddress() {
        return this.address;
    }
}

