/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressTranslationException;
import ghidra.program.util.AddressTranslator;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.SimpleDiffUtility;

public class DefaultAddressTranslator
implements AddressTranslator {
    protected Program destinationProgram;
    protected Program sourceProgram;

    public DefaultAddressTranslator(Program destinationProgram, Program sourceProgram) {
        this.destinationProgram = destinationProgram;
        this.sourceProgram = sourceProgram;
    }

    @Override
    public Program getDestinationProgram() {
        return this.destinationProgram;
    }

    @Override
    public Program getSourceProgram() {
        return this.sourceProgram;
    }

    @Override
    public Address getAddress(Address sourceAddress) {
        return SimpleDiffUtility.getCompatibleAddress((Program)this.sourceProgram, (Address)sourceAddress, (Program)this.destinationProgram);
    }

    @Override
    public boolean isOneForOneTranslator() {
        return true;
    }

    @Override
    public AddressSet getAddressSet(AddressSetView sourceAddressSet) {
        if (sourceAddressSet == null) {
            return null;
        }
        return DiffUtility.getCompatibleAddressSet(sourceAddressSet, this.destinationProgram);
    }

    @Override
    public AddressRange getAddressRange(AddressRange sourceAddressRange) throws AddressTranslationException {
        return DiffUtility.getCompatibleAddressRange(sourceAddressRange, this.destinationProgram);
    }
}

