/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.SystemUtilities;

public class GFileImpl
implements GFile {
    private GFileSystem fileSystem;
    private GFile parentFile;
    private boolean isDirectory = false;
    private long length = -1L;
    private FSRL fsrl;

    public static GFileImpl fromPathString(GFileSystem fileSystem, String path, FSRL fsrl, boolean isDirectory, long length) {
        return GFileImpl.fromPathString(fileSystem, null, path, fsrl, isDirectory, length);
    }

    public static GFileImpl fromPathString(GFileSystem fileSystem, GFile parent, String path, FSRL fsrl, boolean isDirectory, long length) {
        String[] split = path.split("/");
        for (int i = 0; i < split.length - 1; ++i) {
            if (split[i].length() == 0) continue;
            parent = GFileImpl.fromFilename(fileSystem, parent, split[i], true, -1L, null);
        }
        if (fsrl == null) {
            fsrl = GFileImpl.getFSRLFromParent(fileSystem, parent, split[split.length - 1]);
        }
        return new GFileImpl(fileSystem, parent, isDirectory, length, fsrl);
    }

    private static FSRL getFSRLFromParent(GFileSystem fs, GFile parent, String path) {
        FSRL parentFSRL = parent != null ? parent.getFSRL() : fs.getFSRL();
        return parentFSRL.appendPath(path);
    }

    public static GFileImpl fromFilename(GFileSystem fileSystem, GFile parent, String filename, boolean isDirectory, long length, FSRL fsrl) {
        if (fsrl == null) {
            fsrl = GFileImpl.getFSRLFromParent(fileSystem, parent, filename);
        }
        return new GFileImpl(fileSystem, parent, isDirectory, length, fsrl);
    }

    public static GFileImpl fromFSRL(GFileSystem fileSystem, GFile parent, FSRL fsrl, boolean isDirectory, long length) {
        return new GFileImpl(fileSystem, parent, isDirectory, length, fsrl);
    }

    protected GFileImpl(GFileSystem fileSystem, GFile parentFile, boolean isDirectory, long length, FSRL fsrl) {
        this.fileSystem = fileSystem;
        this.fsrl = fsrl;
        this.parentFile = parentFile;
        this.isDirectory = isDirectory;
        this.length = length;
    }

    @Override
    public GFile getParentFile() {
        return this.parentFile;
    }

    @Override
    public String getName() {
        return this.fsrl.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public GFileSystem getFilesystem() {
        return this.fileSystem;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GFile)) {
            return false;
        }
        GFile other = (GFile)obj;
        return SystemUtilities.isEqual((Object)this.fsrl, (Object)other.getFSRL()) && this.isDirectory == other.isDirectory();
    }

    public int hashCode() {
        return this.fsrl.hashCode() ^ Boolean.hashCode(this.isDirectory());
    }

    @Override
    public String getPath() {
        return this.fsrl.getPath();
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    public void setFSRL(FSRL fsrl) {
        this.fsrl = fsrl;
    }
}

