/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.AbstractVariableFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.app.util.viewer.proxy.VariableProxy;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocFieldLocation;
import java.awt.Color;
import java.awt.FontMetrics;
import java.math.BigInteger;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.EmptyIcon;

public class VariableLocFieldFactory
extends AbstractVariableFieldFactory {
    public static final String FIELD_NAME = "Variable Location";
    private static final Icon INVALID_STORAGE_ICON = ResourceManager.loadImage((String)"images/warning.png");

    public VariableLocFieldFactory() {
        super(FIELD_NAME);
    }

    private VariableLocFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    private Icon getStorageIcon(FontMetrics metrics, boolean isInvalid) {
        EmptyIcon icon = new EmptyIcon(18, metrics.getHeight());
        if (isInvalid) {
            icon = new MultiIcon((Icon)icon, new Icon[]{INVALID_STORAGE_ICON});
        }
        return icon;
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Variable)) {
            return null;
        }
        Variable var = (Variable)obj;
        FontMetrics fontMetrics = this.getMetrics(var);
        boolean hasInvalidStorage = !var.isValid();
        String loc = var.getVariableStorage().toString();
        AttributedString as = new AttributedString(this.getStorageIcon(fontMetrics, hasInvalidStorage), loc, hasInvalidStorage ? Color.RED : this.getColor(var), fontMetrics, false, null);
        TextFieldElement field = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)field, this.startX + varWidth, this.width, this.hlProvider);
    }

    public String getOffsetString(int offset) {
        String offString = offset >= 0 ? Integer.toHexString(offset) : "-" + Integer.toHexString(-offset);
        return offString;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj proxy = bf.getProxy();
        if (proxy instanceof VariableProxy) {
            VariableProxy variableProxy = (VariableProxy)proxy;
            Variable sv = variableProxy.getObject();
            return new VariableLocFieldLocation(sv.getProgram(), variableProxy.getLocationAddress(), variableProxy.getObject(), col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Variable sv;
        VariableLocFieldLocation varStorageLoc;
        if (!(loc instanceof VariableLocFieldLocation)) {
            return null;
        }
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Variable && (varStorageLoc = (VariableLocFieldLocation)loc).isLocationFor(sv = (Variable)obj)) {
            return new FieldLocation(index, fieldNum, 0, varStorageLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Variable.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 3;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new VariableLocFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.VARIABLE.getDefaultColor();
    }
}

