/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableModuleRef
extends CliAbstractTable {
    public CliTableModuleRef(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliModuleRefRow row = new CliModuleRefRow(this.readStringIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "ModuleRef Row", 0);
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        return rowDt;
    }

    public class CliModuleRefRow
    extends CliAbstractTableRow {
        public int nameIndex;

        public CliModuleRefRow(int nameIndex) {
            this.nameIndex = nameIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("ModuleRef %s", CliTableModuleRef.this.metadataStream.getStringsStream().getString(this.nameIndex));
        }
    }
}

