/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class LoadCommand
implements StructConverter {
    private long startIndex;
    private int cmd;
    private int cmdsize;

    protected void initLoadCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.startIndex = reader.getPointerIndex();
        this.cmd = reader.readNextInt();
        this.cmdsize = reader.readNextInt();
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public int getCommandType() {
        return this.cmd;
    }

    public int getCommandSize() {
        return this.cmdsize;
    }

    public abstract String getCommandName();

    public abstract void markup(MachHeader var1, FlatProgramAPI var2, Address var3, boolean var4, ProgramModule var5, TaskMonitor var6, MessageLog var7);

    protected final ProgramFragment createFragment(FlatProgramAPI api, Address baseAddress, ProgramModule module) throws Exception {
        Address start = baseAddress.getNewAddress(this.getStartIndex());
        return api.createFragment(module, this.getCommandName(), start, this.getCommandSize());
    }

    protected final void updateMonitor(TaskMonitor monitor) {
        monitor.setMessage("Processing " + this.getCommandName() + "...");
    }
}

