/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffSymbolAuxName
implements CoffSymbolAux {
    private int tagIndex;
    private byte[] unused1;
    private short size;
    private byte[] unused2;

    CoffSymbolAuxName(BinaryReader reader) throws IOException {
        this.tagIndex = reader.readNextInt();
        this.unused1 = reader.readNextByteArray(2);
        this.size = reader.readNextShort();
        this.unused2 = reader.readNextByteArray(10);
    }

    public int getTagIndex() {
        return this.tagIndex;
    }

    public byte[] getUnused1() {
        return this.unused1;
    }

    public short getSize() {
        return this.size;
    }

    public byte[] getUnused2() {
        return this.unused2;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this);
    }
}

