/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.match;

import ghidra.app.plugin.match.SubroutineMatch;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolTable;
import java.util.ArrayList;

public class FunctionMatchSet
extends ArrayList<SubroutineMatch> {
    public final Program aProgram;
    public final Program bProgram;
    private final SymbolTable aSymbolTable;
    private final SymbolTable bSymbolTable;

    public FunctionMatchSet(Program aProgram, Program bProgram) {
        this.aProgram = aProgram;
        this.bProgram = bProgram;
        this.aSymbolTable = aProgram.getSymbolTable();
        this.bSymbolTable = bProgram.getSymbolTable();
    }

    public SubroutineMatch[] getMatches() {
        SubroutineMatch[] theMatches = this.toArray(new SubroutineMatch[0]);
        return theMatches;
    }

    public int getLength(Address addr, Program aProgram) {
        Function func = aProgram.getFunctionManager().getFunctionContaining(addr);
        AddressSetView asv = func.getBody();
        return (int)asv.getNumAddresses();
    }

    public int getLength(Address addr) {
        return this.getLength(addr, this.aProgram);
    }

    SymbolTable getATable() {
        return this.aSymbolTable;
    }

    SymbolTable getBTable() {
        return this.bSymbolTable;
    }
}

