/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableDataObject;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class InstructionTableCellRenderer
extends GhidraTableCellRenderer {
    public InstructionTableCellRenderer(Font font) {
        super(font);
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Object value = data.getValue();
        JTable table = data.getTable();
        int column = data.getColumnViewIndex();
        boolean isSelected = data.isSelected();
        boolean hasFocus = data.hasFocus();
        if (value == null) {
            return this;
        }
        InstructionTableDataObject dataObject = (InstructionTableDataObject)value;
        String strData = dataObject.getData();
        GTableCellRenderingData renderData = data.copyWithNewValue((Object)strData);
        JLabel theRenderer = (JLabel)super.getTableCellRendererComponent(renderData);
        this.setTextAttributes(table, value, column);
        this.setBackgroundAttributes(isSelected, hasFocus, dataObject);
        this.setBorderAttributes(dataObject, theRenderer);
        this.setForegroundAttributes(dataObject, theRenderer);
        return this;
    }

    private void setBorderAttributes(InstructionTableDataObject dataObject, JLabel theRenderer) {
        theRenderer.setBorder(dataObject.getBorder());
    }

    private void setForegroundAttributes(InstructionTableDataObject dataObject, JLabel theRenderer) {
        theRenderer.setForeground(dataObject.getForegroundColor());
        Font newFont = theRenderer.getFont().deriveFont(dataObject.getFontStyle());
        theRenderer.setFont(newFont);
    }

    private void setBackgroundAttributes(boolean isSelected, boolean hasFocus, InstructionTableDataObject dataObject) {
        Color backgroundColor = dataObject.getBackgroundColor();
        if (backgroundColor != null) {
            if (isSelected || hasFocus) {
                this.setBackground(backgroundColor.darker());
            } else {
                this.setBackground(backgroundColor);
            }
        }
    }

    private void setTextAttributes(JTable table, Object value, int col) {
        this.setHorizontalAlignment(2);
        TableModel model = table.getModel();
        this.configureFont(table, model, col);
        this.setOpaque(true);
    }
}

