/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

class CreateArrayAction
extends ListingContextAction {
    private static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(91, 0);
    private FunctionPlugin plugin;

    public CreateArrayAction(FunctionPlugin plugin) {
        super("Define Array", plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.setPopupMenu(plugin.getDataActionMenuName(null));
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DataType"));
        this.initKeyStroke(DEFAULT_KEY_STROKE);
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    private void setPopupMenu(String name) {
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", "Array..."}, null, "Array"));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection()) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (this.plugin.isValidDataLocation(location)) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location));
            return true;
        }
        if (location instanceof VariableLocation) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location));
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        VariableLocation varLoc;
        Variable var;
        ProgramLocation loc = context.getLocation();
        Function fun = this.plugin.getFunction(context);
        if (loc instanceof FunctionSignatureFieldLocation) {
            DataType dt = fun.getReturnType();
            if (dt == DataType.VOID) {
                dt = DataType.DEFAULT;
            }
            if (dt.getLength() < 1) {
                return;
            }
            int n = this.getNumElements(dt, Integer.MAX_VALUE, 1);
            if (n == 0) {
                return;
            }
            ArrayDataType array = new ArrayDataType(dt, n, dt.getLength());
            this.plugin.createData((DataType)array, context, false);
        } else if (loc instanceof VariableLocation && (var = (varLoc = (VariableLocation)loc).getVariable()).isStackVariable()) {
            int n;
            DataType dt = var.getDataType();
            int len = var.getLength();
            int defaultElements = this.plugin.getMaxStackVariableSize(fun, var);
            if (defaultElements <= 0) {
                defaultElements = 1;
            }
            if ((n = this.getNumElements(dt, Integer.MAX_VALUE, defaultElements)) == 0) {
                return;
            }
            ArrayDataType array = new ArrayDataType(dt, n, len);
            this.plugin.createData((DataType)array, context, true);
        }
    }

    private int getNumElements(DataType dt, int maxElements, int initial) {
        NumberInputDialog dialog = new NumberInputDialog(dt.getDisplayName() + " Elements", initial, 1, maxElements);
        if (!dialog.show()) {
            return 0;
        }
        return dialog.getValue();
    }
}

