/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.util.exception.UsrException;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class UnpackageAction
extends CompositeEditorTableAction {
    private static final ImageIcon unpackageIcon = ResourceManager.loadImage((String)"images/Unpackage.gif");
    private static final String ACTION_NAME = "Unpackage Component";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Replace the selected composite with its components";
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(61, 0);
    private static String[] popupPath = new String[]{"Unpackage Component"};

    public UnpackageAction(StructureEditorProvider provider) {
        super(provider, "Editor: Unpackage Component", GROUP_NAME, popupPath, null, unpackageIcon);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        int currentRowIndex = this.model.getSelection().getFieldRange(0).getStart().getIndex().intValue();
        int subComps = this.model.getNumSubComponents(currentRowIndex);
        if (subComps > 1000) {
            String question = "Are you sure you want to unpackage " + subComps + " components?";
            String title = "Continue with unpackage?";
            int response = OptionDialog.showYesNoDialog((Component)this.model.getProvider().getComponent(), (String)title, (String)question);
            if (response != 1) {
                return;
            }
        }
        try {
            ((StructureEditorModel)this.model).unpackage(currentRowIndex);
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage(), true);
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isUnpackageAllowed());
    }
}

