/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.codebrowser.hover.ReferenceListingHover;
import ghidra.app.services.CodeFormatService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Reference Hover", description="Pop-up display of \"referred to\" code in the Code Browser.", servicesProvided={ListingHoverService.class}, servicesRequired={CodeFormatService.class}, eventsConsumed={ProgramClosedPluginEvent.class})
public class ReferenceListingHoverPlugin
extends Plugin {
    private ReferenceListingHover referenceHoverService;

    public ReferenceListingHoverPlugin(PluginTool tool) {
        super(tool);
        this.referenceHoverService = new ReferenceListingHover(tool);
        this.registerServiceProvided(ListingHoverService.class, this.referenceHoverService);
    }

    public void init() {
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)event;
            this.referenceHoverService.programClosed(ev.getProgram());
        }
    }

    public void dispose() {
        this.referenceHoverService.dispose();
    }
}

