/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.services.GraphService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.graph.GraphSelectionHandler;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.util.ProgramSelection;
import java.util.ArrayList;

class ASTGraphSelectionHandler
implements GraphSelectionHandler {
    private GraphService graphService;
    private HighFunction hfunction;
    private int graphType;
    private boolean active = false;
    private boolean enabled = true;

    ASTGraphSelectionHandler(GraphService graphService, HighFunction hfunction, int graphType) {
        this.graphService = graphService;
        this.hfunction = hfunction;
        this.graphType = graphType;
    }

    public String getGraphType() {
        return this.graphType == 1 ? "AST Data Flow" : "AST Control Flow";
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void locate(String location) {
    }

    public String locate(Object locationObject) {
        if (this.graphType != 0) {
            return null;
        }
        if (!(locationObject instanceof Address)) {
            return null;
        }
        Address addr = (Address)locationObject;
        ArrayList blocks = this.hfunction.getBasicBlocks();
        for (PcodeBlockBasic block : blocks) {
            Address start = block.getStart();
            Address stop = block.getStop();
            if (addr.compareTo((Object)start) < 0 || addr.compareTo((Object)stop) > 0) continue;
            return Integer.toString(block.getIndex());
        }
        return addr.toString();
    }

    public boolean notify(String notificationType) {
        return false;
    }

    public void select(String[] selectedIndexes) {
        if (this.graphType != 0) {
            return;
        }
        AddressSet set = new AddressSet();
        Address location = null;
        ArrayList blocks = this.hfunction.getBasicBlocks();
        for (String indexStr : selectedIndexes) {
            try {
                int index = Integer.parseInt(indexStr);
                PcodeBlockBasic block = (PcodeBlockBasic)blocks.get(index);
                Address start = block.getStart();
                set.addRange(start, block.getStop());
                if (location != null && start.compareTo((Object)location) >= 0) continue;
                location = start;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (location != null) {
            this.graphService.fireLocationEvent(location);
        }
        this.graphService.fireSelectionEvent((Object)new ProgramSelection((AddressSetView)set));
    }

    public String[] select(Object ghidraSelection) {
        return null;
    }
}

