/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.DecompilerParameterIdCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;

public class DecompilerFunctionAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Decompiler Parameter ID";
    private static final String DESCRIPTION = "Creates parameter and local variables for a Function using Decompiler.\nWARNING: This can take a SIGNIFICANT Amount of Time!\n         Turned off by default for large programs\nYou can run this later using \"Analysis->Decompiler Parameter ID\"";
    private static final long MEDIUM_SIZE_PROGRAM = 0x200000L;
    private static final String ENABLED_PROPERTY = "DecompilerParameterAnalyzer.enabled";
    private static final String OPTION_NAME_CLEAR_LEVEL = "Analysis Clear Level";
    private static final String OPTION_NAME_COMMIT_DATA_TYPES = "Commit Data Types";
    private static final String OPTION_NAME_COMMIT_VOID_RETURN = "Commit Void Return Values";
    private static final String OPTION_NAME_DECOMPILER_TIMEOUT_SECS = "Analysis Decompiler Timeout (sec)";
    private static final String OPTION_DESCRIPTION_CLEAR_LEVEL = "Set level for amount of existing parameter data to clear";
    private static final String OPTION_DESCRIPTION_COMMIT_DATA_TYPES = "Turn on to commit data types";
    private static final String OPTION_DESCRIPTION_COMMIT_VOID_RETURN = "Turn on to lock in 'void' return values";
    private static final String OPTION_DESCRIPTION_DECOMPILER_TIMEOUT_SECS = "Set timeout in seconds for analyzer decompiler calls.";
    private static final SourceType OPTION_DEFAULT_CLEAR_LEVEL = SourceType.ANALYSIS;
    private static final boolean OPTION_DEFAULT_COMMIT_DATA_TYPES = true;
    private static final boolean OPTION_DEFAULT_COMMIT_VOID_RETURN = false;
    public static final int OPTION_DEFAULT_DECOMPILER_TIMEOUT_SECS = 60;
    private SourceType sourceTypeClearLevelOption = OPTION_DEFAULT_CLEAR_LEVEL;
    private boolean commitDataTypesOption = true;
    private boolean commitVoidReturnOption = false;
    private int decompilerTimeoutSecondsOption = 60;

    public DecompilerFunctionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after().after());
        this.setSupportsOneTimeAnalysis();
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        DecompilerParameterIdCmd cmd = new DecompilerParameterIdCmd(set, this.sourceTypeClearLevelOption, this.commitDataTypesOption, this.commitVoidReturnOption, this.decompilerTimeoutSecondsOption);
        cmd.applyTo((DomainObject)program, monitor);
        return true;
    }

    public boolean canAnalyze(Program program) {
        return program.getLanguage().supportsPcode();
    }

    public boolean getDefaultEnablement(Program program) {
        if (this.isDisabledFromProperty()) {
            return false;
        }
        long numAddr = program.getMemory().getNumAddresses();
        return numAddr < 0x200000L && "Portable Executable (PE)".equals(program.getExecutableFormat());
    }

    private boolean isDisabledFromProperty() {
        String defaultEnabledProperty = System.getProperty(ENABLED_PROPERTY);
        if (defaultEnabledProperty == null) {
            return false;
        }
        boolean isEnabled = Boolean.parseBoolean(defaultEnabledProperty);
        return !isEnabled;
    }

    public void registerOptions(Options options, Program program) {
        HelpLocation helpLocation = new HelpLocation("AutoAnalysisPlugin", "Auto_Analysis_Option_Instruction" + this.getAnalysisType());
        options.registerOption(OPTION_NAME_CLEAR_LEVEL, (Object)SourceType.ANALYSIS, helpLocation, OPTION_DESCRIPTION_CLEAR_LEVEL);
        options.registerOption(OPTION_NAME_COMMIT_DATA_TYPES, (Object)this.commitDataTypesOption, helpLocation, OPTION_DESCRIPTION_COMMIT_DATA_TYPES);
        options.registerOption(OPTION_NAME_COMMIT_VOID_RETURN, (Object)this.commitVoidReturnOption, helpLocation, OPTION_DESCRIPTION_COMMIT_VOID_RETURN);
        options.registerOption(OPTION_NAME_DECOMPILER_TIMEOUT_SECS, (Object)this.decompilerTimeoutSecondsOption, helpLocation, OPTION_DESCRIPTION_DECOMPILER_TIMEOUT_SECS);
    }

    public void optionsChanged(Options options, Program program) {
        this.sourceTypeClearLevelOption = (SourceType)options.getEnum(OPTION_NAME_CLEAR_LEVEL, (Enum)SourceType.ANALYSIS);
        this.decompilerTimeoutSecondsOption = options.getInt(OPTION_NAME_DECOMPILER_TIMEOUT_SECS, this.decompilerTimeoutSecondsOption);
        this.commitDataTypesOption = options.getBoolean(OPTION_NAME_COMMIT_DATA_TYPES, this.commitDataTypesOption);
        this.commitVoidReturnOption = options.getBoolean(OPTION_NAME_COMMIT_VOID_RETURN, this.commitVoidReturnOption);
    }
}

