/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.mbr;

import java.util.HashMap;
import org.catacombae.jparted.lib.ps.PartitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MBRPartitionType {
    UNUSED(0, PartitionType.EMPTY),
    FAT12(1, PartitionType.FAT12),
    FAT16_SMALL(4, PartitionType.FAT16),
    DOS_EXTENDED(5, PartitionType.DOS_EXTENDED),
    FAT16_LARGE(6, PartitionType.FAT16),
    NT_INSTALLABLE_FS(7, PartitionType.NT_OS2_IFS),
    FAT32(11, PartitionType.FAT32),
    FAT32_INT13HX(12, PartitionType.FAT32),
    FAT16_LARGE_INT13HX(14, PartitionType.FAT16),
    DOS_EXTENDED_INT13HX(15, PartitionType.DOS_EXTENDED),
    EISA_OR_OEM(18, PartitionType.SPECIAL),
    DYNAMIC_VOLUME(66, PartitionType.SPECIAL),
    PM_HIBERNATION(-124, PartitionType.SPECIAL),
    NT_MULTIDISK_FAT16(-122, PartitionType.SPECIAL),
    NT_MULTIDISK_NTFS(-121, PartitionType.SPECIAL),
    LAPTOP_HIBERNATION(-96, PartitionType.SPECIAL),
    DELL_OEM(-34, PartitionType.SPECIAL),
    IBM_OEM(-2, PartitionType.SPECIAL),
    GPT_PROTECTIVE(-18, PartitionType.GPT_PROTECTIVE),
    EFI_SYSTEM_ON_MBR(-17, PartitionType.EFI_SYSTEM),
    APPLE_UFS(-88, PartitionType.APPLE_UFS),
    APPLE_HFS(-81, PartitionType.APPLE_HFS_CONTAINER),
    LINUX_SWAP(-126, PartitionType.LINUX_SWAP),
    LINUX_NATIVE(-125, PartitionType.LINUX_NATIVE),
    UNKNOWN;

    private static HashMap<Byte, MBRPartitionType> reverseLookupTable;
    private final Byte mbrType;
    private final PartitionType enumType;

    private MBRPartitionType(byte mbrType, PartitionType enumType) {
        if (enumType == null) {
            throw new IllegalArgumentException("enumType == null");
        }
        this.mbrType = mbrType;
        this.enumType = enumType;
        MBRPartitionType.addReverseLookupReference(mbrType, this);
    }

    private MBRPartitionType() {
        this.mbrType = null;
        this.enumType = null;
    }

    public Byte getMBRType() {
        return this.mbrType;
    }

    public PartitionType getGeneralType() {
        return this.enumType;
    }

    private static void addReverseLookupReference(byte b, MBRPartitionType t) {
        if (reverseLookupTable == null) {
            reverseLookupTable = new HashMap();
        }
        reverseLookupTable.put(b, t);
    }

    public static MBRPartitionType fromMBRType(byte mbrType) {
        MBRPartitionType type = reverseLookupTable.get(mbrType);
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }
}

