/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.BTIndexRecord;
import org.catacombae.hfsexplorer.types.hfsplus.BTNode;

public abstract class BTIndexNode
extends BTNode {
    protected final BTIndexRecord[] records;
    protected final short[] offsets;

    protected BTIndexNode(byte[] data, int offset, int nodeSize) {
        super(data, offset, nodeSize);
        this.offsets = new short[Util.unsign((short)this.nodeDescriptor.getNumRecords()) + 1];
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = Util.readShortBE((byte[])data, (int)(offset + nodeSize - (i + 1) * 2));
        }
        this.records = new BTIndexRecord[this.offsets.length - 1];
    }

    public BTIndexRecord getIndexRecord(int index) {
        return this.records[index];
    }

    public BTIndexRecord[] getIndexRecords() {
        BTIndexRecord[] copy = new BTIndexRecord[this.records.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.records[i];
        }
        return copy;
    }
}

