/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.OffsetCharSequence;
import org.apache.jackrabbit.core.query.lucene.RangeScan;
import org.apache.jackrabbit.core.query.lucene.TransformConstants;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;

class WildcardTermEnum
extends FilteredTermEnum
implements TransformConstants {
    private final Matcher pattern;
    private final String field;
    private final String prefix;
    private boolean endEnum = false;
    private final OffsetCharSequence input;
    private final int transform;

    public WildcardTermEnum(IndexReader reader, String field, String propName, String pattern, int transform) throws IOException {
        int idx;
        if (transform < 0 || transform > 2) {
            throw new IllegalArgumentException("invalid transform parameter");
        }
        this.field = field;
        this.transform = transform;
        if (transform == 0) {
            for (idx = 0; idx < pattern.length() && Character.isLetterOrDigit(pattern.charAt(idx)); ++idx) {
            }
            this.prefix = propName == null ? pattern.substring(0, idx) : FieldNames.createNamedValue(propName, pattern.substring(0, idx));
        } else {
            this.prefix = FieldNames.createNamedValue(propName, "");
        }
        this.input = new OffsetCharSequence(this.prefix.length(), this.prefix, transform);
        this.pattern = this.createRegexp(pattern.substring(idx)).matcher(this.input);
        if (transform == 0) {
            this.setEnum(reader.terms(new Term(field, this.prefix)));
        } else {
            this.setEnum(new LowerUpperCaseTermEnum(reader, field, propName, pattern, transform));
        }
    }

    protected boolean termCompare(Term term) {
        if (this.transform == 0) {
            if (term.field() == this.field && term.text().startsWith(this.prefix)) {
                this.input.setBase(term.text());
                return this.pattern.reset().matches();
            }
            this.endEnum = true;
            return false;
        }
        return true;
    }

    public float difference() {
        return 1.0f;
    }

    protected boolean endEnum() {
        return this.endEnum;
    }

    private Pattern createRegexp(String likePattern) {
        StringBuffer regexp = new StringBuffer();
        boolean escaped = false;
        block4: for (int i = 0; i < likePattern.length(); ++i) {
            if (likePattern.charAt(i) == '\\') {
                if (escaped) {
                    regexp.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (Character.isLetterOrDigit(likePattern.charAt(i))) {
                if (escaped) {
                    regexp.append("\\\\").append(likePattern.charAt(i));
                    escaped = false;
                    continue;
                }
                regexp.append(likePattern.charAt(i));
                continue;
            }
            if (escaped) {
                regexp.append('\\').append(likePattern.charAt(i));
                escaped = false;
                continue;
            }
            switch (likePattern.charAt(i)) {
                case '_': {
                    regexp.append('.');
                    continue block4;
                }
                case '%': {
                    regexp.append(".*");
                    continue block4;
                }
                default: {
                    regexp.append('\\').append(likePattern.charAt(i));
                }
            }
        }
        return Pattern.compile(regexp.toString(), 32);
    }

    private class LowerUpperCaseTermEnum
    extends TermEnum {
        private final Map orderedTerms = new LinkedHashMap();
        private final Iterator it;
        private Term current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LowerUpperCaseTermEnum(IndexReader reader, String field, String propName, String pattern, int transform) throws IOException {
            if (transform != 1 && transform != 2) {
                throw new IllegalArgumentException("transform");
            }
            boolean neverMatches = false;
            for (int i = 0; i < pattern.length() && !neverMatches; ++i) {
                if (transform == 1) {
                    neverMatches = Character.isUpperCase(pattern.charAt(i));
                    continue;
                }
                if (transform != 2) continue;
                neverMatches = Character.isLowerCase(pattern.charAt(i));
            }
            if (!neverMatches) {
                ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
                try {
                    int idx;
                    for (idx = 0; idx < pattern.length() && Character.isLetterOrDigit(pattern.charAt(idx)); ++idx) {
                    }
                    String patternPrefix = pattern.substring(0, idx);
                    if (patternPrefix.length() == 0) {
                        String prefix = FieldNames.createNamedValue(propName, "");
                        String limit = FieldNames.createNamedValue(propName, "\uffff");
                        rangeScans.add(new RangeScan(reader, new Term(field, prefix), new Term(field, limit)));
                    } else {
                        StringBuffer lowerLimit = new StringBuffer(patternPrefix.toUpperCase());
                        lowerLimit.setCharAt(0, Character.toLowerCase(lowerLimit.charAt(0)));
                        String prefix = FieldNames.createNamedValue(propName, lowerLimit.toString());
                        StringBuffer upperLimit = new StringBuffer(patternPrefix.toLowerCase());
                        upperLimit.append('\uffff');
                        String limit = FieldNames.createNamedValue(propName, upperLimit.toString());
                        rangeScans.add(new RangeScan(reader, new Term(field, prefix), new Term(field, limit)));
                        prefix = FieldNames.createNamedValue(propName, patternPrefix.toUpperCase());
                        upperLimit = new StringBuffer(patternPrefix.toLowerCase());
                        upperLimit.setCharAt(0, Character.toUpperCase(upperLimit.charAt(0)));
                        upperLimit.append('\uffff');
                        limit = FieldNames.createNamedValue(propName, upperLimit.toString());
                        rangeScans.add(new RangeScan(reader, new Term(field, prefix), new Term(field, limit)));
                    }
                    Iterator it = rangeScans.iterator();
                    while (it.hasNext()) {
                        RangeScan scan = (RangeScan)((Object)it.next());
                        do {
                            Term t;
                            if ((t = scan.term()) == null) continue;
                            WildcardTermEnum.this.input.setBase(t.text());
                            if (!WildcardTermEnum.this.pattern.reset().matches()) continue;
                            this.orderedTerms.put(t, new Integer(scan.docFreq()));
                        } while (scan.next());
                    }
                }
                finally {
                    Iterator it = rangeScans.iterator();
                    while (it.hasNext()) {
                        RangeScan scan = (RangeScan)((Object)it.next());
                        try {
                            scan.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            this.it = this.orderedTerms.keySet().iterator();
            this.getNext();
        }

        public boolean next() {
            this.getNext();
            return this.current != null;
        }

        public Term term() {
            return this.current;
        }

        public int docFreq() {
            Integer docFreq = (Integer)this.orderedTerms.get(this.current);
            return docFreq != null ? docFreq : 0;
        }

        public void close() {
        }

        private void getNext() {
            this.current = this.it.hasNext() ? (Term)this.it.next() : null;
        }
    }
}

