/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.modifier;

import java.util.ArrayList;
import java.util.List;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;

public class MDEFIModifier
extends MDParsableItem {
    public static final char SPACE = ' ';
    public static final String PTR64 = "__ptr64";
    private static final String UNALIGNED = "__unaligned";
    private static final String RESTRICT = "__restrict";
    private boolean isPointer64;
    private boolean isUnaligned;
    private boolean isRestrict;
    private List<CvPrefix> prefixList = new ArrayList<CvPrefix>();

    public MDEFIModifier(MDMang dmang) {
        super(dmang);
    }

    public boolean isPointer64() {
        return this.isPointer64;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    @Override
    protected void parseInternal() {
        boolean prefixDone = false;
        block5: while (!prefixDone) {
            switch (this.dmang.peek()) {
                case 'E': {
                    this.isPointer64 = true;
                    this.prefixList.add(CvPrefix._PTR64);
                    this.dmang.increment();
                    continue block5;
                }
                case 'F': {
                    this.isUnaligned = true;
                    this.prefixList.add(CvPrefix._UNALIGNED);
                    this.dmang.increment();
                    continue block5;
                }
                case 'I': {
                    this.isRestrict = true;
                    this.prefixList.add(CvPrefix._RESTRICT);
                    this.dmang.increment();
                    continue block5;
                }
            }
            prefixDone = true;
        }
    }

    public String emit(StringBuilder builder) {
        StringBuilder left = new StringBuilder();
        StringBuilder right = new StringBuilder();
        for (CvPrefix p : this.prefixList) {
            switch (p) {
                case _UNALIGNED: {
                    left.insert(0, "__unaligned ");
                    break;
                }
            }
        }
        for (CvPrefix p : this.prefixList) {
            switch (p) {
                case _PTR64: {
                    right.append(" __ptr64");
                    break;
                }
                case _RESTRICT: {
                    right.append(" __restrict");
                    break;
                }
            }
        }
        if (builder.length() == 0 && left.length() != 0 && right.length() != 0) {
            left.setLength(left.length() - 1);
        }
        builder.insert(0, left);
        if (builder.length() != 0 && builder.charAt(builder.length() - 1) == ' ' && right.length() != 0 && right.charAt(0) == ' ') {
            builder.setLength(builder.length() - 1);
        }
        builder.append((CharSequence)right);
        return builder.toString();
    }

    private static enum CvPrefix {
        _PTR64,
        _UNALIGNED,
        _RESTRICT;

    }
}

