/*
 * Decompiled with CFR 0.152.
 */
package ghidra.macosx;

import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import java.io.IOException;
import java.util.List;

public final class MacosxLanguageHelper {
    public static LanguageCompilerSpecPair getLanguageCompilerSpecPair(LanguageService languageService, int cpuType, int cpuSubType) throws IOException {
        Processor ARM = Processor.findOrPossiblyCreateProcessor((String)"ARM");
        Processor ARM64 = Processor.findOrPossiblyCreateProcessor((String)"AARCH64");
        Processor x86 = Processor.findOrPossiblyCreateProcessor((String)"x86");
        Processor PowerPC = Processor.findOrPossiblyCreateProcessor((String)"PowerPC");
        Processor processor = null;
        Endian endian = null;
        Integer size = null;
        String variant = "default";
        CompilerSpecID compilerSpecID = new CompilerSpecID("default");
        if (cpuType == 12) {
            processor = ARM;
            endian = Endian.LITTLE;
            if (cpuSubType == 6) {
                variant = "v6";
            } else if (cpuSubType == 9 || cpuSubType == 10 || cpuSubType == 11 || cpuSubType == 12 || cpuSubType == 0) {
                variant = "v7";
            }
        } else if (cpuType == 7 || cpuType == 0x1000007) {
            processor = x86;
            endian = Endian.LITTLE;
            size = cpuType == 0x1000007 ? 64 : 32;
            compilerSpecID = new CompilerSpecID("gcc");
        } else if (cpuType == 18 || cpuType == 0x1000012) {
            processor = PowerPC;
            endian = Endian.BIG;
            size = cpuType == 0x1000012 ? 64 : 32;
            compilerSpecID = new CompilerSpecID("macosx");
        } else if (cpuType == 0x100000C) {
            processor = ARM64;
            endian = Endian.LITTLE;
            size = 64;
            variant = "v8A";
        }
        LanguageCompilerSpecQuery query = new LanguageCompilerSpecQuery(processor, endian, size, variant, compilerSpecID);
        List pairs = languageService.getLanguageCompilerSpecPairs(query);
        if (pairs.size() > 0) {
            if (pairs.size() > 1) {
                throw new LanguageNotFoundException("Too many languages for " + Integer.toHexString(cpuType) + "." + Integer.toHexString(cpuSubType));
            }
            LanguageCompilerSpecPair pair = (LanguageCompilerSpecPair)pairs.get(0);
            return new LanguageCompilerSpecPair(pair.languageID, pair.compilerSpecID);
        }
        throw new LanguageNotFoundException("Unable to locate language for " + Integer.toHexString(cpuType) + "." + Integer.toHexString(cpuSubType));
    }
}

