/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.iso9660.ISO9660Constants;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ISO9660BaseVolume
implements StructConverter {
    private long volumeIndex;
    private byte typeCode;
    private byte[] identifier;
    private byte version;

    public ISO9660BaseVolume(BinaryReader reader) throws IOException {
        this.volumeIndex = reader.getPointerIndex();
        this.typeCode = reader.readNextByte();
        this.identifier = reader.readNextByteArray(ISO9660Constants.MAGIC_BYTES.length);
        this.version = reader.readNextByte();
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = new StructureDataType("ISO9660VolumeDescriptor", 0);
        struc.add(BYTE, "Type Code", "Type of volume descriptor");
        struc.add((DataType)new ArrayDataType(BYTE, this.identifier.length, 1), "Standard Identifier", "Always 'CD001'");
        struc.add(BYTE, "Version", "Always 0x01");
        return struc;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Type Code: 0x" + Integer.toHexString(this.typeCode) + " => " + this.getTypeCodeString() + "\n");
        buff.append("Standard Identifier: " + new String(this.identifier).trim() + "\n");
        buff.append("Version: 0x" + Integer.toHexString(this.version) + "\n");
        return buff.toString();
    }

    public String getTypeCodeString() {
        switch (this.typeCode) {
            case 0: {
                return "Boot Record";
            }
            case 1: {
                return "Primary Volume Descriptor";
            }
            case 2: {
                return "Supplementary Volume Descriptor";
            }
            case 3: {
                return "Volume Partition Descriptor";
            }
            case -1: {
                return "Volume Descriptor Set Terminator";
            }
        }
        return "";
    }

    public byte getTypeCode() {
        return this.typeCode;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public byte getVersion() {
        return this.version;
    }

    public long getVolumeIndex() {
        return this.volumeIndex;
    }
}

